package com.bizunited.nebula.venus.sdk.vo;

import java.util.Date;

import org.springframework.format.annotation.DateTimeFormat;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 对照片墙内容分页查询条件的描述
 * @author yinwenjie
 */
public class PhotoWallDocumentDto {
  /**
   * 顶级租户编号，精确查询（必须传入）
   */
  private String tenantCode;
  /**
   * 照片墙类型编号（必须传入）
   */
  private String code;
  /**
   * 外部单据号（也就是业务单据号）
   */
  private String billCode;
  /**
   * 创建时间起，范围查询
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeStart;
  /**
   * 创建时间止，范围查询
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date createTimeEnd;
  /**
   * 修改时间起，范围查询
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTimeStart;
  /**
   * 修改时间止，范围查询
   */
  @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd HH:mm:ss")
  @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
  private Date modifyTimeEnd;
  /**
   * 创建者
   */
  private String createAccount;
  /**
   * 修改者
   */
  private String modifyAccount;
  /**
   * 进行分词匹配查询的关键信息
   */
  private String content; 
  
  public String getTenantCode() {
    return tenantCode;
  }
  public void setTenantCode(String tenantCode) {
    this.tenantCode = tenantCode;
  }
  public String getCode() {
    return code;
  }
  public void setCode(String code) {
    this.code = code;
  }
  public String getBillCode() {
    return billCode;
  }
  public void setBillCode(String billCode) {
    this.billCode = billCode;
  }
  public Date getCreateTimeStart() {
    return createTimeStart;
  }
  public void setCreateTimeStart(Date createTimeStart) {
    this.createTimeStart = createTimeStart;
  }
  public Date getCreateTimeEnd() {
    return createTimeEnd;
  }
  public void setCreateTimeEnd(Date createTimeEnd) {
    this.createTimeEnd = createTimeEnd;
  }
  public Date getModifyTimeStart() {
    return modifyTimeStart;
  }
  public void setModifyTimeStart(Date modifyTimeStart) {
    this.modifyTimeStart = modifyTimeStart;
  }
  public Date getModifyTimeEnd() {
    return modifyTimeEnd;
  }
  public void setModifyTimeEnd(Date modifyTimeEnd) {
    this.modifyTimeEnd = modifyTimeEnd;
  }
  public String getCreateAccount() {
    return createAccount;
  }
  public void setCreateAccount(String createAccount) {
    this.createAccount = createAccount;
  }
  public String getModifyAccount() {
    return modifyAccount;
  }
  public void setModifyAccount(String modifyAccount) {
    this.modifyAccount = modifyAccount;
  }
  public String getContent() {
    return content;
  }
  public void setContent(String content) {
    this.content = content;
  }
}
