package com.bizunited.nebula.venus.sdk.vo;

/**
 * 特性照片墙类型下,ES文档的特定结构描述——每个字段的描述都在这里
 * @author yinwenjie
 */
public class PhotoWallDocumentStructureFieldVo {
  /**
   * 字段的英文名
   */
  private String fieldCode;
  /**
   * 字段的java类型
   */
  private String fieldClass;
  /**
   * 字段中文意义
   */
  private String fieldName;
  /**
   * 该字段在ES中是否启用分词检索（如果启用分词检索，则固定使用ik_max_word） 
   */
  private boolean analyzer;
  /**
   * 该字段在ES中的字段类型，目前支持keyword、text、long、integer、short、byte、double、float、date
   */
  private String esFieldType;
  public String getFieldCode() {
    return fieldCode;
  }
  public void setFieldCode(String fieldCode) {
    this.fieldCode = fieldCode;
  }
  public String getFieldClass() {
    return fieldClass;
  }
  public void setFieldClass(String fieldClass) {
    this.fieldClass = fieldClass;
  }
  public String getFieldName() {
    return fieldName;
  }
  public void setFieldName(String fieldName) {
    this.fieldName = fieldName;
  }
  public boolean isAnalyzer() {
    return analyzer;
  }
  public void setAnalyzer(boolean analyzer) {
    this.analyzer = analyzer;
  }
  public String getEsFieldType() {
    return esFieldType;
  }
  public void setEsFieldType(String esFieldType) {
    this.esFieldType = esFieldType;
  }
}
