package com.bizunited.platform.core.annotations;

import javax.persistence.Inheritance;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * NebulaServiceMethod注解用于表示，当前Spring中的某个接口定义的方法，可以直接业务构建平台的静态服务源，</br>
 * 暴露给表单模板、列表模板、页面流引擎、工作流引擎，作为后端事件或者后端数据源来进行使用。
 * 一个标准的服务源在被调用时可以传导一些标准的入参参数，包括几种类型：</p>
 * 1、实时外参，这部分参数由外部系统在调用表单实例时实时传入，当这个表单实例调用设定好的后端事件或者后端数据源是，这部分外参将作为K-V的形式传导给暴露的服务接口</br>
 * 2、当前表单实例的操作者（用户名），既是当前已经登录业务系统，正在对表单实例进行操作的人员信息（将使用java标准的权限规范java.security.Principal接口进行描述）。</br>
 * 3、如果使用当前服务源的页面调用是一个create或者update性质的调用，当前服务源的入参还可以自动绑定本次业务调用的模型对象作为入参，例如“订单”静态模型的类描述：Order对象。</br>
 * 4、……TODO 更多支持的参数敬请期待
 * <p>
 * 注意：</br>
 * a、目前该注解只能配合Spring Ioc容器使用，也即是说只有被标定接口的实现已经托管到Spring了，才能被扫描到</br>
 * b、为了保证服务源的定义符合MVC架构模式的编码要求，本注释只能配合spring 的@Service注解使用</p>
 * @author yinwenjie
 */
@Inheritance
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = {java.lang.annotation.ElementType.METHOD })
@Documented
public @interface NebulaServiceMethod {
  /**
   * 服务源名称，名称不能重复<br>
   * 服务源重载，只要服务暴露的名字不一样即可，服务名必须是英文，例如“UserTestService.createTest”
   */
  String name();
  /**
   * 指示当前服务的中文描述
   */
  String desc();
  /**
   * 如果存在返回信息，且返回信息是一个业务对象，则可以使用该属性指定这个业务对象的哪些直接或间接属性需要进行返回<br>
   * 例如:"buyer,product"。表示这个返回对象中的两个关联属性对象buyer,product需要返回
   */
  String returnPropertiesFilter() default "_";
  
  /**
   * 该属性和returnPropertiesFilter意义刚好相反，采用“黑名单”方式进行对象中关联属性、集合属性的过滤</br>
   * 只有不存在于其中的对象关联属性和集合属性，能够被返回</p>
   * 
   * 请注意该属性和returnPropertiesFilter属性的优先级关系：后者优先级高于前者;
   * @return
   */
  String returnPropertiesFilterB() default "_";
  
  /**
   * 指定该方法应用的范围，目前支持：读操作(read)，写操作(write)</br>
   * 从V2.2+版本开始，该属性的作用被减弱，只是在日志中体现服务源的操作性质
   */
  ScopeType scope() default ScopeType.NULL;
  /**
   * 当该方法应用范围时写操作(write)，需指定详情查询方法，用于表单日志中对数据前后变化的查询
   * 默认值为findDetailsByFormInstanceId,参数值就是表单实例ID</br>
   * 从V2.2+版本开始，写差异日志信息的工作方式发生了变化，该属性已作废
   */
  @Deprecated
  String recordQuery() default "";
  /**
   * 当该方法应用范围是写操作(write)，且是更新操作时，需指定(非表单数据)业务数据的更新方法。用于调用表单update方法时，满足业务场景的更新操作
   * 默认值为空，表示当前更新操作没有涉及业务场景的更新</br>
   * 从V2.2+版本开始，写差异日志信息的工作方式发生了变化，该属性已作废
   */
  @Deprecated
  String recoveryService() default "";
  /**
   * TODO 注释未写
   */
  Class<?>[] requestHandleTypes() default Void.class;
  /**
   * TODO 注释未写
   */
  Class<?>[] responseHandleTypes() default Void.class;
  /**
   * TODO 注释未写
   */
  String requestHandleGroup()  default "";
  
  /**
   * TODO 注释未写
   */
  String responseHandleGroup()  default "";
  
  /**
   * NULL：匿名类型，无需提前指定的方法操作类型</br>
   * READ：读操作类型，方法只是对数据进行读取操作，不会对数据层进行数据改变</br>
   * WRITE：写操作类型，方法处理过程中，需要对数据层进行数据更改</br>
   */
  enum ScopeType{
    NULL,READ,WRITE
  }
}