package com.bizunited.platform.core.annotations;

import javax.persistence.Inheritance;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 该注解用于在服务源NebulaServicableMethod注解之上，区分服务源哪些具有数据权限
 * 且只有标注了ServicableDataAuth的服务源，才能进行数据权限配置
 */
@Inheritance
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = {java.lang.annotation.ElementType.METHOD })
@Documented
public @interface ServicableDataAuth {
}
