/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dicts"})
public class DictController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictController.class);
    @Autowired
    private DictService dictService;

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u6807\u9898\u7ec4")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            return this.buildHttpResultW(this.dictService.findAll(), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u542f\u7528\u72b6\u6001\u67e5\u8be2\u5b57\u5178")
    @RequestMapping(value={"/findByStatus"}, method={RequestMethod.GET})
    public ResponseModel findByStatus(@RequestParam(name="dictStatus") @ApiParam(name="dictStatus", value="\u662f\u5426\u5df2\u4e0a\u67b6\u542f\u7528") Boolean dictStatus) {
        try {
            return this.buildHttpResultW(this.dictService.findByStatus(dictStatus), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7684\u7f16\u53f7,\u7c7b\u578b,\u72b6\u6001\u67e5\u8be2")
    @RequestMapping(value={"/findByConditions"}, method={RequestMethod.GET})
    public ResponseModel findByConditions(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7684\u7c7b\u578b\u7f16\u53f7") String dictCode, @RequestParam(name="dictTitle") @ApiParam(name="dictTitle", value="\u5b57\u5178\u7684\u7c7b\u578b\u6807\u9898") String dictTitle, @RequestParam(name="dictType") @ApiParam(name="dictType", value="\u5b57\u5178\u7684\u8fd0\u7528\u8303\u56f4\uff0c\u6682\u65f6\u9650\u5b9a\u4e3a \u901a\u7528/\u4e1a\u52a1") String dictType, @RequestParam(name="dictStatus") @ApiParam(name="dictStatus", value="\u662f\u5426\u5df2\u4e0a\u67b6\u542f\u7528") Boolean dictStatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page page = this.dictService.findByConditions(dictCode, dictTitle, dictType, dictStatus, pageable);
            return this.buildHttpResultW(page, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u5b57\u5178\u4fe1\u606f") @RequestBody DictVo dictVo, @RequestParam(name="categoryId") @ApiParam(name="categoryId", value="\u5b57\u5178\u5206\u7c7bid") String categoryId) {
        LOGGER.debug("\u5f85\u65b0\u589e/\u4fee\u6539\u7684\u5b57\u5178\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dictVo));
        try {
            return this.buildHttpResultW(this.dictService.create(dictVo, categoryId), new String[]{"dictItems"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u5b57\u5178\u4fe1\u606f") @RequestBody DictVo dictVo, @RequestParam(name="categoryId") @ApiParam(name="categoryId", value="\u5b57\u5178\u5206\u7c7bid") String categoryId) {
        LOGGER.debug("\u5f85\u65b0\u589e/\u4fee\u6539\u7684\u5b57\u5178\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)dictVo));
        try {
            return this.buildHttpResultW(this.dictService.update(dictVo, categoryId), new String[]{"dictItems"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5b57\u5178\u7c7b\u590d\u5236\u5347\u7ea7")
    @RequestMapping(value={"/upgrade"}, method={RequestMethod.POST})
    public ResponseModel upgrade(@RequestParam(name="newDictCode") @ApiParam(name="newDictCode", value="\u65b0\u5b57\u5178\u7f16\u7801") String newDictCode, @RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        LOGGER.debug("\u65b0\u5b57\u5178\u7f16\u7801\uff1a{},\u590d\u5236\u7684\u65e7\u5b57\u5178\u4fe1\u606f\uff1a{}", (Object)newDictCode, (Object)dictCode);
        try {
            return this.buildHttpResultW(this.dictService.upgrade(newDictCode, dictCode), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e0a\u67b6\u5b57\u5178")
    @RequestMapping(value={"/update"}, method={RequestMethod.PATCH})
    public ResponseModel update(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        LOGGER.debug("\u4e0a\u67b6\u5b57\u5178\u7f16\u7801\uff1a{}", (Object)dictCode);
        try {
            return this.buildHttpResultW(this.dictService.onshelf(dictCode), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u67d0\u5b57\u5178")
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public ResponseModel delete(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        LOGGER.debug("\u4e0a\u67b6\u5b57\u5178\u7f16\u7801\uff1a{}", (Object)dictCode);
        try {
            this.dictService.delete(dictCode);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u4e00\u4e2a\u6216\u8005\u591a\u4e2aID\u4fe1\u606f\uff0c\u67e5\u8be2\u5b57\u5178\u660e\u7ec6\u4fe1\u606f\uff0c\u5305\u62ec\u5b57\u5178\u7684\u5404\u79cd\u5173\u8054\u4fe1\u606f\uff08\u4f46\u662f\u4e0d\u5305\u62ec\u4e0b\u7ea7\u5173\u8054\u4fe1\u606f\uff09")
    @GetMapping(value={"/findDetailsByIds"})
    public ResponseModel findDetailsByIds(@RequestParam(name="dictIds") @ApiParam(name="dictIds", value="\u5b57\u5178ids") String[] dictIds) {
        try {
            Set dictVos = this.dictService.findDetailsByIds(dictIds);
            return this.buildHttpResult(dictVos);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u6570\u636e\u5b57\u5178\u7684ID\u4fe1\u606f\uff0c\u67e5\u8be2\u6700\u7ec8\u6ee1\u8db3\u8fd9\u4e9bid\u7f16\u53f7\u7684\u6570\u636e\u6761\u76ee\u3002")
    @GetMapping(value={"/countByIds"})
    public ResponseModel countByIds(@RequestParam(name="ids") @ApiParam(name="ids", value="\u5b57\u5178ids") String[] ids) {
        try {
            int count = this.dictService.countByIds(ids);
            return this.buildHttpResult(count);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\uff08\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff09")
    @GetMapping(value={"/findDetailsByDictCode"})
    public ResponseModel findDetailsByDictCode(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        try {
            DictVo dictVo = this.dictService.findDetailsByDictCode(dictCode);
            return this.buildHttpResultW(dictVo, new String[]{"category", "dictItems"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2")
    @GetMapping(value={"/findByDictCode"})
    public ResponseModel findByDictCode(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        try {
            DictVo dictVo = this.dictService.findByDictCode(dictCode);
            return this.buildHttpResultW(dictVo, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u6279\u91cf\u67e5\u8be2")
    @GetMapping(value={"/findDetailsByDictCodes"})
    public ResponseModel findDetailsByDictCodes(@RequestParam(name="dictCodes") @ApiParam(name="dictCodes", value="\u5b57\u5178\u7f16\u7801") String[] dictCodes) {
        try {
            Set dictVos = this.dictService.findDetailsByDictCodes(dictCodes);
            return this.buildHttpResultW(dictVos, new String[]{"dictItems"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

