/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.DictImportService;
import com.bizunited.platform.dictionary.common.vo.DictImportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(value="DictImportController")
@RestController
@RequestMapping(value={"/v1/nebula/dictImport"})
public class DictImportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictImportController.class);
    @Autowired
    private DictImportService dictImportService;

    @ApiOperation(value="\u4e0a\u4f20\u8fc1\u5165\u6587\u4ef6")
    @RequestMapping(value={"/upload"}, method={RequestMethod.POST})
    public ResponseModel upload(MultipartFile file) {
        try {
            DictImportVo entity = this.dictImportService.upload(file);
            return this.buildHttpResultW(entity, new String[]{"creator", "executor"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"execute"})
    @ApiOperation(value="\u6839\u636eID\u6267\u884c\u5bfc\u5165")
    public ResponseModel execute(@RequestParam @ApiParam(value="\u5bfc\u5165ID") String id, @RequestParam(defaultValue="0") @ApiParam(value="\u5bfc\u5165\u6267\u884c\u6a21\u5f0f0\uff1a\u5df2\u5b58\u5728\u8df3\u8fc7\uff0c1\uff1a\u5df2\u5b58\u5728\u65b0\u589e\uff0c2\uff1a\u5df2\u5b58\u5728\u66f4\u65b0") Integer mode) {
        try {
            DictImportVo migrateImport = this.dictImportService.execute(id, mode);
            return this.buildHttpResultW(migrateImport, new String[]{"detail"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    @GetMapping(value={"findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(required=true) @ApiParam(value="\u4e3b\u952eID", required=true) String id) {
        try {
            DictImportVo migrateImport = this.dictImportService.findDetailsById(id);
            return this.buildHttpResultW(migrateImport, new String[]{"detail"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findAll"})
    @ApiOperation(value="\u67e5\u8be2\u6570\u636e\u5b57\u5178\u5bfc\u5165\u65e5\u5fd7")
    public ResponseModel findAll() {
        try {
            List migrateImports = this.dictImportService.findAll();
            return this.buildHttpResultW(migrateImports, new String[]{"createUser", "executeUser"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

