package com.bizunited.platform.dictionary.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.DictImportService;
import com.bizunited.platform.dictionary.common.vo.DictImportVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据字典导入管理
 * @Author: zengxingwang
 * @Date: 2020/5/19 18:24
 */
@Api(value = "DictImportController")
@RestController
@RequestMapping("/v1/nebula/dictImport")
public class DictImportController extends BaseController {

  /** 日志 */
  private static final Logger LOGGER = LoggerFactory.getLogger(DictImportController.class);

  @Autowired
  private DictImportService dictImportService;

  /**
   * 上传迁入文件
   * @param file
   * @return
   */
  @ApiOperation(value = "上传迁入文件")
  @RequestMapping(value = "/upload", method = RequestMethod.POST)
  public ResponseModel upload(MultipartFile file) {
    try {
      DictImportVo entity = dictImportService.upload(file);
      return this.buildHttpResultW(entity, "creator", "executor");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据ID执行导入
   * @param id
   * @param mode
   * @return
   */
  @PostMapping("execute")
  @ApiOperation("根据ID执行导入")
  public ResponseModel execute(@RequestParam @ApiParam("导入ID") String id,
                               @RequestParam(defaultValue = "0") @ApiParam("导入执行模式0：已存在跳过，1：已存在新增，2：已存在更新") Integer mode) {
    try {
      DictImportVo migrateImport = dictImportService.execute(id, mode);
      return buildHttpResultW(migrateImport, "detail");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @ApiOperation("根据ID查询详情")
  @GetMapping("findDetailsById")
  public ResponseModel findDetailsById(@RequestParam(required = true) @ApiParam(value = "主键ID", required = true) String id) {
    try {
      DictImportVo migrateImport = dictImportService.findDetailsById(id);
      return buildHttpResultW(migrateImport, "detail");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  /**
   * 查询导入日志
   * @return
   */
  @GetMapping("findAll")
  @ApiOperation("查询数据字典导入日志")
  public ResponseModel findAll() {
    try {
      List<DictImportVo> migrateImports = dictImportService.findAll();
      return buildHttpResultW(migrateImports, "createUser", "executeUser");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

}
