/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dictItems"})
public class DictItemController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictItemController.class);
    @Autowired
    private DictItemService dictItemService;

    @ApiOperation(value="\u6839\u636e\u5b57\u5178\u7f16\u7801\u67e5\u8be2\u6240\u6709\u5b50\u9879")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u6307\u5b9a\u7684\u5b57\u5178\u7f16\u7801") String dictCode) {
        try {
            return this.buildHttpResultW(this.dictItemService.findItemsByCode(dictCode), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4e3a\u5b57\u5178\u7c7b \u4fee\u6539/\u6dfb\u52a0/\u5220\u9664 \u660e\u7ec6\u9879")
    @RequestMapping(value={"/update"}, method={RequestMethod.POST})
    public ResponseModel update(@RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode, @ApiParam(name="\u5b57\u5178\u660e\u7ec6\u4fe1\u606f") @RequestBody Set<DictItemVo> items) {
        LOGGER.debug("\u5f85\u65b0\u589e/\u4fee\u6539\u7684\u5b57\u5178\u7f16\u7801\uff1a{},\u5b57\u5178\u4fe1\u606f\uff1a{}", (Object)dictCode, (Object)JSON.toJSONString(items));
        try {
            return this.buildHttpResultW(this.dictItemService.save(dictCode, items), new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u542f\u7528\u5b57\u5178")
    @PutMapping(value={"/enable"})
    public ResponseModel enable(@ApiParam(name="\u5b57\u5178ID") @RequestParam(value="id") String id) {
        try {
            DictItemVo dictItem = this.dictItemService.enable(id);
            return this.buildHttpResultW(dictItem, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7981\u7528\u5b57\u5178")
    @PutMapping(value={"/disable"})
    public ResponseModel disable(@ApiParam(name="\u5b57\u5178ID") @RequestParam(value="id") String id) {
        try {
            DictItemVo dictItem = this.dictItemService.disable(id);
            return this.buildHttpResultW(dictItem, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u660e\u7ec6\u9879(\u53ea\u80fd\u6dfb\u52a0\u5355\u4e2a\u6570\u636e\u5b57\u5178\u660e\u7ec6\u9879)")
    @PostMapping(value={""})
    public ResponseModel create(@ApiParam(name="\u521b\u5efa\u5b57\u5178\u660e\u7ec6\u9879") @RequestBody DictItemVo dictItem, @RequestParam(name="dictCode") @ApiParam(name="dictCode", value="\u5b57\u5178\u7f16\u7801") String dictCode) {
        try {
            DictItemVo result = this.dictItemService.create(dictCode, dictItem);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u660e\u7ec6\u9879(\u6839\u636eid\u67e5\u8be2\u660e\u7ec6)")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@ApiParam(name="\u5b57\u5178\u660e\u7ec6\u9879id") @RequestParam(value="id") String id) {
        try {
            DictItemVo result = this.dictItemService.findDetailsById(id);
            return this.buildHttpResultW(result, new String[]{"dict"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5b57\u5178dictCode\u548c\u5b57\u5178\u503c\u7684key\u67e5\u8be2\u4e00\u4e2a\u6570\u636e\u5b57\u5178\u503c\u8be6\u7ec6")
    @GetMapping(value={"/findByKeyAndDictCode"})
    public ResponseModel findByKeyAndDictCode(@ApiParam(name="\u5b57\u5178code") @RequestParam(value="dictCode") String dictCode, @ApiParam(name="\u5b57\u5178\u503ckey") @RequestParam(value="key") String key) {
        try {
            DictItemVo result = this.dictItemService.findByKeyAndDictCode(dictCode, key);
            return this.buildHttpResultW(result, new String[]{"dictEntity"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

