/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.alibaba.fastjson.JSON;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.dictCategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dictCategories"})
public class DictCategoryController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictCategoryController.class);
    @Autowired
    private DictCategoryService dictCategoryService;

    @ApiOperation(value="\u521b\u5efa\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.POST})
    public ResponseModel create(@ApiParam(name="\u5b57\u5178\u5206\u7c7b\u4fe1\u606f") @RequestBody DictCategoryVo dictCategoryVo, @RequestParam(name="parentId", required=false) @ApiParam(name="parentId", value="\u7236\u7ea7\u5b57\u5178ID", required=false) String parentId) {
        LOGGER.debug("\u521b\u5efa\u5b57\u5178\u5206\u7c7b\uff1a{}", (Object)JSON.toJSONString((Object)dictCategoryVo));
        try {
            DictCategoryVo entity = this.dictCategoryService.create(dictCategoryVo, parentId);
            return this.buildHttpResultW(entity, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u4fee\u6539\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={""}, method={RequestMethod.PATCH})
    public ResponseModel update(@ApiParam(name="\u5b57\u5178\u5206\u7c7b\u4fe1\u606f") @RequestBody DictCategoryVo dictCategoryVo) {
        LOGGER.debug("\u4fee\u6539\u5b57\u5178\u5206\u7c7b\uff1a{}", (Object)JSON.toJSONString((Object)dictCategoryVo));
        try {
            DictCategoryVo entity = this.dictCategoryService.update(dictCategoryVo);
            return this.buildHttpResultW(entity, new String[]{""});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u8bbe\u7f6e\u5b57\u5178\u5206\u7c7b\u5c42\u7ea7")
    @RequestMapping(value={"/bind"}, method={RequestMethod.POST})
    public ResponseModel bind(@RequestParam(name="childId") @ApiParam(name="childId", value="\u5b50\u7ea7\u5b57\u5178ID") String childId, @RequestParam(name="parentId") @ApiParam(name="parentId", value="\u7236\u7ea7\u5b57\u5178ID") String parentId) {
        try {
            this.dictCategoryService.bind(childId, parentId);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6570\u636e\u5b57\u5178\u4e1a\u52a1\u7f16\u53f7code\u8fdb\u884c\u67e5\u8be2\uff0c\u4e0d\u5305\u62ec\u4efb\u4f55\u5173\u8054\u4fe1\u606f")
    @RequestMapping(value={"/findByCode"}, method={RequestMethod.GET})
    public ResponseModel findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u4e1a\u52a1\u7f16\u53f7code\u5728\u5168\u7cfb\u7edf\u552f\u4e00") String code) {
        try {
            DictCategoryVo current = this.dictCategoryService.findByCode(code);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u5b57\u5178\u5206\u7c7b")
    @RequestMapping(value={"/findAll"}, method={RequestMethod.GET})
    public ResponseModel findAll() {
        try {
            Set entities = this.dictCategoryService.findAll();
            ArrayList<DictCategoryVo> entitiesList = new ArrayList<DictCategoryVo>();
            entitiesList.addAll(entities);
            this.filterDictCate(entitiesList);
            ResponseModel responseModel = new ResponseModel();
            responseModel.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            responseModel.setData(entitiesList);
            responseModel.setSuccess(Boolean.valueOf(true));
            responseModel.setResponseCode(ResponseCode.E0);
            return responseModel;
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    private void filterDictCate(List<DictCategoryVo> entities) {
        if (CollectionUtils.isEmpty(entities)) {
            return;
        }
        for (DictCategoryVo entity : entities) {
            HashSet child;
            entity.setParentCategory(null);
            Set dicts = entity.getDicts();
            if (!CollectionUtils.isEmpty((Collection)dicts)) {
                for (DictVo dict : dicts) {
                    dict.setCategory(null);
                    if (CollectionUtils.isEmpty((Collection)dict.getDictItems())) continue;
                    for (DictItemVo item : dict.getDictItems()) {
                        item.setDictEntity(null);
                    }
                }
            }
            if ((child = entity.getChildCategory()) == null) {
                child = new HashSet();
            }
            ArrayList<DictCategoryVo> childList = new ArrayList<DictCategoryVo>();
            childList.addAll(child);
            if (CollectionUtils.isEmpty(child)) continue;
            this.filterDictCate(childList);
        }
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u57fa\u672c\u4fe1\u606f\uff0c\u6ca1\u6709\u4efb\u4f55\u5173\u8054\u4fe1\u606f")
    @GetMapping(value={"/findById"})
    public ResponseModel findById(@RequestParam(value="id") @ApiParam(name="id", value="\u5b57\u5178\u5206\u7ec4id") String id) {
        try {
            DictCategoryVo current = this.dictCategoryService.findById(id);
            return this.buildHttpResultW(current, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b57\u5178\u5206\u7c7b\u7684\u57fa\u672c\u4fe1\u606f\u548c\u5173\u8054\u4fe1\u606f\uff08\u4f46\u662f\u4e0d\u5305\u62ec\u5b57\u5178\u5206\u7c7b\u7684\u5b50\u7ea7\u96c6\u5408\u5173\u8054\uff09")
    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(value="id") @ApiParam(name="id", value="\u5b57\u5178\u5206\u7ec4id") String id) {
        try {
            DictCategoryVo current = this.dictCategoryService.findDetailsById(id);
            return this.buildHttpResultW(current, new String[]{"parentCategory"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5206\u7ec4id\u5220\u9664\u5206\u7ec4\uff08\u4e0d\u80fd\u5220\u9664\u6709\u5b57\u5178\u7684\u5206\u7ec4\uff09")
    @DeleteMapping(value={"deleteById"})
    public ResponseModel deleteById(@RequestParam(value="id") @ApiParam(name="id", value="\u5b57\u5178\u5206\u7ec4id") String id) {
        try {
            this.dictCategoryService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

