/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.DictExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="DictExportController")
@RestController
@RequestMapping(value={"/v1/nebula/dictExport"})
public class DictExportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictExportController.class);
    @Autowired
    private DictExportService dictExportService;

    @GetMapping(value={"findAll"})
    @ApiOperation(value="\u67e5\u8be2\u5bfc\u51fa\u65e5\u5fd7")
    public ResponseModel findAll() {
        try {
            List exports = this.dictExportService.findAll();
            return this.buildHttpResultW(exports, new String[]{"createUser"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u6307\u5b9a\u7f16\u53f7\u7684\u6570\u636e\u5b57\u5178", notes="\u4f20\u5165\u5bfc\u51fa\u7684\u6570\u636eID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    @GetMapping(value={"/exportDict"})
    public void exportDict(@RequestParam(required=false) @ApiParam(value="\u7b5b\u9009\u7684\u6570\u636eID") String[] dictIds, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.dictExportService.exportDict(dictIds);
            Validate.isTrue((bytes != null && bytes.length != 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u6570\u636e\u5b57\u5178-", time, ".zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }
}

