package com.bizunited.platform.dictionary.web.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.DictItemOrgMappingService;
import com.bizunited.platform.user.common.vo.OrganizationExtendVo;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

@RestController
@RequestMapping("/v1/nebula/dctItemOrgMapping")
public class DictItemOrgMappingController extends BaseController {

  private static final Logger LOGGER = LoggerFactory.getLogger(DictItemOrgMappingController.class);
  @Autowired
  private DictItemOrgMappingService dictOrgMappingService;

  @ApiOperation(value = "创建组织并且进行绑定数据字典值")
  @RequestMapping(value = "/createAndBindDictItem", method = RequestMethod.POST)
  public ResponseModel createAndBindDictItem(@RequestBody @ApiParam(name = "vo", value = "组织机构") OrganizationExtendVo vo,
                                 @RequestParam(name = "id") String id) {
    try {
      OrganizationExtendVo extendVo = this.dictOrgMappingService.createAndBindDictItem(vo, id);
      return buildHttpResultW(extendVo, "organization");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "更新组织并且进行绑定数据字典值")
  @RequestMapping(value = "/updateAndBindDictItem", method = RequestMethod.POST)
  public ResponseModel updateAndBindDictItem(@RequestBody @ApiParam(name = "vo", value = "组织机构") OrganizationExtendVo vo,
                                             @RequestParam(name = "id") String id) {
    try {
      OrganizationExtendVo extendVo = this.dictOrgMappingService.updateAndBindDictItem(vo, id);
      return buildHttpResultW(extendVo, "organization");
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据当前层级查询层级上一层的所关联的组织")
  @RequestMapping(value = "/queryPage", method = RequestMethod.GET)
  public ResponseModel queryPage(@RequestParam(name = "dictItemId") @ApiParam(name = "dictItemId", value = "指定的字典值的id") String dictItemId,
                                 @PageableDefault(value = 50) Pageable pageable) {
    try {
      Page<OrganizationVo> vos = this.dictOrgMappingService.queryPage(dictItemId, pageable);
      return buildHttpResultW(vos);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "组织机构条件查询分页")
  @GetMapping(value="/findByConditions")
  public ResponseModel findByConditions(@RequestParam(required = false) @ApiParam(name="id" , value="组织机构id") String id,
                                        @RequestParam(required = false) @ApiParam(name="orgName" , value="组织机构名称") String orgName,
                                        @RequestParam(required = false) @ApiParam(name="code" , value="组织机构编码") String code,
                                        @RequestParam(required = false) @ApiParam(name="createUser" , value="组织机构创建人") String createUser,
                                        @RequestParam(required = false) @ApiParam(name="tstatus" , value="组织机构状态") Integer tstatus,
                                        @PageableDefault(value = 50) Pageable pageable){
    try {
      Page<JSONObject> jsonObjects = this.dictOrgMappingService.findByConditions(id, orgName, code, createUser, tstatus, pageable);
      return this.buildHttpResult(jsonObjects);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据组织code查询组织信息")
  @RequestMapping(value = "/findDetailByCode", method = RequestMethod.GET)
  public ResponseModel findDetailByCode(@RequestParam(name = "code") String code) {
    try {
      JSONObject jsonObject = this.dictOrgMappingService.findDetailByCode(code);
      return buildHttpResultW(jsonObject);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }

  @ApiOperation(value = "根据组织机构名字和关联的字典值层级id查询")
  @RequestMapping(value = "/findOrgByConditions", method = RequestMethod.GET)
  public ResponseModel findOrgByConditions(@RequestParam(name = "dictItemId") String dictItemId,
                                           @RequestParam(name = "orgName") String orgName) {
    try {
      List<OrganizationVo> organizationVos = this.dictOrgMappingService.findOrgByConditions(dictItemId, orgName);
      return buildHttpResultW(organizationVos);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return buildHttpResultForException(e);
    }
  }
}
