/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.web.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.service.DictItemOrgMappingService;
import com.bizunited.platform.user.common.vo.OrganizationExtendVo;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/nebula/dctItemOrgMapping"})
public class DictItemOrgMappingController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictItemOrgMappingController.class);
    @Autowired
    private DictItemOrgMappingService dictOrgMappingService;

    @ApiOperation(value="\u521b\u5efa\u7ec4\u7ec7\u5e76\u4e14\u8fdb\u884c\u7ed1\u5b9a\u6570\u636e\u5b57\u5178\u503c")
    @RequestMapping(value={"/createAndBindDictItem"}, method={RequestMethod.POST})
    public ResponseModel createAndBindDictItem(@RequestBody @ApiParam(name="vo", value="\u7ec4\u7ec7\u673a\u6784") OrganizationExtendVo vo, @RequestParam(name="id") String id) {
        try {
            OrganizationExtendVo extendVo = this.dictOrgMappingService.createAndBindDictItem(vo, id);
            return this.buildHttpResultW(extendVo, new String[]{"organization"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u66f4\u65b0\u7ec4\u7ec7\u5e76\u4e14\u8fdb\u884c\u7ed1\u5b9a\u6570\u636e\u5b57\u5178\u503c")
    @RequestMapping(value={"/updateAndBindDictItem"}, method={RequestMethod.POST})
    public ResponseModel updateAndBindDictItem(@RequestBody @ApiParam(name="vo", value="\u7ec4\u7ec7\u673a\u6784") OrganizationExtendVo vo, @RequestParam(name="id") String id) {
        try {
            OrganizationExtendVo extendVo = this.dictOrgMappingService.updateAndBindDictItem(vo, id);
            return this.buildHttpResultW(extendVo, new String[]{"organization"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u5f53\u524d\u5c42\u7ea7\u67e5\u8be2\u5c42\u7ea7\u4e0a\u4e00\u5c42\u7684\u6240\u5173\u8054\u7684\u7ec4\u7ec7")
    @RequestMapping(value={"/queryPage"}, method={RequestMethod.GET})
    public ResponseModel queryPage(@RequestParam(name="dictItemId") @ApiParam(name="dictItemId", value="\u6307\u5b9a\u7684\u5b57\u5178\u503c\u7684id") String dictItemId, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page vos = this.dictOrgMappingService.queryPage(dictItemId, pageable);
            return this.buildHttpResultW(vos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u7ec4\u7ec7\u673a\u6784\u6761\u4ef6\u67e5\u8be2\u5206\u9875")
    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestParam(required=false) @ApiParam(name="id", value="\u7ec4\u7ec7\u673a\u6784id") String id, @RequestParam(required=false) @ApiParam(name="orgName", value="\u7ec4\u7ec7\u673a\u6784\u540d\u79f0") String orgName, @RequestParam(required=false) @ApiParam(name="code", value="\u7ec4\u7ec7\u673a\u6784\u7f16\u7801") String code, @RequestParam(required=false) @ApiParam(name="createUser", value="\u7ec4\u7ec7\u673a\u6784\u521b\u5efa\u4eba") String createUser, @RequestParam(required=false) @ApiParam(name="tstatus", value="\u7ec4\u7ec7\u673a\u6784\u72b6\u6001") Integer tstatus, @PageableDefault(value=50) Pageable pageable) {
        try {
            Page jsonObjects = this.dictOrgMappingService.findByConditions(id, orgName, code, createUser, tstatus, pageable);
            return this.buildHttpResult(jsonObjects);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7code\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f")
    @RequestMapping(value={"/findDetailByCode"}, method={RequestMethod.GET})
    public ResponseModel findDetailByCode(@RequestParam(name="code") String code) {
        try {
            JSONObject jsonObject = this.dictOrgMappingService.findDetailByCode(code);
            return this.buildHttpResultW(jsonObject, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7\u673a\u6784\u540d\u5b57\u548c\u5173\u8054\u7684\u5b57\u5178\u503c\u5c42\u7ea7id\u67e5\u8be2")
    @RequestMapping(value={"/findOrgByConditions"}, method={RequestMethod.GET})
    public ResponseModel findOrgByConditions(@RequestParam(name="dictItemId") String dictItemId, @RequestParam(name="orgName") String orgName) {
        try {
            List organizationVos = this.dictOrgMappingService.findOrgByConditions(dictItemId, orgName);
            return this.buildHttpResultW(organizationVos, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

