package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.service.feign.fallback.DictCategoryFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 数据字典分组服务的feign调用
 * @Author: zengxingwang
 * @Date: 2020/3/20 10:16
 */
@FeignClient(qualifier = "DictCategoryFeignClient", name = "${dictionary.application.name}", path = "/v1/nebula/dictCategories", fallback = DictCategoryFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface DictCategoryFeignClient {

  /**
   * 创建字典分类
   * @param dictCategoryVo
   * @param parentId
   * @return
   */
  @PostMapping("")
  ResponseModel create(@RequestBody DictCategoryVo dictCategoryVo, @RequestParam(name = "parentId") String parentId);

  /**
   * 修改字典分类
   * @param dictCategoryVo
   * @return
   */
  @PatchMapping("")
  ResponseModel update(@RequestBody DictCategoryVo dictCategoryVo);

  /**
   * 设置字典分类层级
   * @param childId
   * @param parentId
   * @return
   */
  @PostMapping("/bind")
  ResponseModel bind(@RequestParam(name = "childId") String childId, @RequestParam(name = "parentId") String parentId);

  /**
   * 根据数据字典业务编号code进行查询，不包括任何关联信息
   * @param code
   * @return
   */
  @GetMapping("/findByCode")
  ResponseModel findByCode(@RequestParam(name = "code") String code);

  /**
   * 查询所有字典分类
   * @return
   **/
  @GetMapping("/findAll")
  ResponseModel findAll();

  /**
   * 根据id查询基本信息，没有任何关联信息
   * @param id
   * @return
   */
  @GetMapping("/findById")
  ResponseModel findById(@RequestParam(name = "id") String id);

  /**
   * 根据id查询字典分类的基本信息和关联信息（但是不包括字典分类的子级集合关联）
   * @param id
   * @return
   */
  @GetMapping("/findDetailsById")
  ResponseModel findDetailsById(@RequestParam(name = "id") String id);

  /**
   * 根据分组id删除分组（不能删除有字典的分组）
   * @param id
   * @return
   */
  @DeleteMapping("/deleteById")
  ResponseModel deleteById(@RequestParam(name = "id") String id);
}
