package com.bizunited.platform.dictionary.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.service.feign.DictImportFeignClient;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

/**
 * 字典导入feign的熔断器
 * @Author: zengxingwang
 * @Date: 2020/5/20 9:59
 */
@Component
public class DictImportFeignClientFallback implements DictImportFeignClient {

  @Override
  public ResponseModel upload(MultipartFile file) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据ID执行导入
   * @param id
   * @param mode
   * @return
   */
  @Override
  public ResponseModel execute(String id, Integer mode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }
}
