package com.bizunited.platform.dictionary.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.service.feign.DictItemFeignClient;
import org.springframework.stereotype.Component;

import java.util.Set;

/**
 * 字典明细服务的feign调用熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/20 10:16
 */
@Component
public class DictItemFeignClientFallback implements DictItemFeignClient {
  /**
   * 根据字典编码查询所有子项
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel findByCode(String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 为字典类 修改/添加/删除 明细项
   * @param dictCode
   * @param items
   * @return
   */
  @Override
  public ResponseModel update(String dictCode, Set<DictItemVo> items) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据字典ID启用字典
   * @param id
   * @return
   */
  @Override
  public ResponseModel enable(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据字典ID禁用字典
   * @param id
   * @return
   */
  @Override
  public ResponseModel disable(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 创建字典明细项(添加单个)
   * @param dictItem
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel create(DictItemVo dictItem, String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }
}
