package com.bizunited.platform.dictionary.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.dictionary.common.service.DictExportService;
import com.bizunited.platform.dictionary.common.vo.DictExportVo;
import com.bizunited.platform.dictionary.service.feign.DictExportFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import feign.Response;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.io.IOException;
import java.util.List;

/**
 * 数据字典导出实现
 * @Author: zengxingwang
 * @Date: 2020/5/21 14:00
 */
@Service("DictExportServiceImpl")
public class DictExportServiceImpl implements DictExportService {

  @Autowired
  private DictExportFeignClient dictExportFeignClient;

  @Override
  public DictExportVo save(DictExportVo export) {
    throw new UnsupportedOperationException("暂不支持");
  }

  @Override
  public List<DictExportVo> findAll() {
    ResponseModel response = dictExportFeignClient.findAll();
    return JsonUtils.convert(response.getSuccessDataOrElse(Lists.newArrayList()), new TypeReference<List<DictExportVo>>() {});
  }

  /**
   * 导出数据字典
   * @param dictIds
   * @return
   */
  @Override
  public byte[] exportDict(String[] dictIds) throws IOException {
    Response response = dictExportFeignClient.exportDict(dictIds);
    return FileUtils.readByte(response);
  }
}
