/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.dictionary.common.service.dictCategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.service.feign.DictCategoryFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DictCategoryServiceImpl")
public class DictCategoryServiceImpl
implements DictCategoryService {
    @Autowired
    private DictCategoryFeignClient dictCategoryFeignClient;

    public DictCategoryVo create(DictCategoryVo dictCategoryVo, String parentId) {
        Validate.notNull((Object)dictCategoryVo, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dictCategoryVo.getId()), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictCategoryVo.getCateName(), (String)"\u5b57\u5178\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictCategoryVo.getCateCode(), (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)dictCategoryVo.getCateCode()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.create(dictCategoryVo, parentId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictCategoryVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictCategoryVo.class);
    }

    public DictCategoryVo update(DictCategoryVo dictCategoryVo) {
        Validate.notNull((Object)dictCategoryVo, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictCategoryVo.getId(), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.update(dictCategoryVo);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictCategoryVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictCategoryVo.class);
    }

    public void bind(String childId, String parentId) {
        Validate.notBlank((CharSequence)childId, (String)"\u5b50\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)parentId, (String)"\u7236\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.bind(childId, parentId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public Set<DictCategoryVo> findAll() {
        ResponseModel response = this.dictCategoryFeignClient.findAll();
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newLinkedHashSet()), (TypeReference)new TypeReference<LinkedHashSet<DictCategoryVo>>(){});
    }

    public DictCategoryVo findById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.findById(id);
        return (DictCategoryVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictCategoryVo.class);
    }

    public DictCategoryVo findDetailsById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.findDetailsById(id);
        return (DictCategoryVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictCategoryVo.class);
    }

    public DictCategoryVo findByCode(String code) {
        Validate.notBlank((CharSequence)code, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.findByCode(code);
        return (DictCategoryVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictCategoryVo.class);
    }

    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5b57\u5178\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        ResponseModel response = this.dictCategoryFeignClient.deleteById(id);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public String importCategory(String id, Map<String, DictCategoryVo> dictCategoryMap) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }
}

