package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.configuration.FeignSupportConfig;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.service.feign.fallback.DictImportFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.multipart.MultipartFile;

/**
 * 数据字典导入的feign调用
 * @Author: zengxingwang
 * @Date: 2020/5/20 9:57
 */
@FeignClient(qualifier = "DictImportFeignClient", name = "${dictionary.application.name}", path = "/v1/nebula/dictImport", fallback = DictImportFeignClientFallback.class, configuration = {FeignRequestInterceptor.class, FeignSupportConfig.class})
public interface DictImportFeignClient {

  /**
   * 上传迁入文件
   * @param file
   * @return
   */
  @PostMapping(value = "/upload", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
  ResponseModel upload(@RequestPart("file") MultipartFile file);

  /**
   * 根据ID执行导入
   * @param id
   * @param mode
   * @return
   */
  @PostMapping("/execute")
  ResponseModel execute(@RequestParam(name = "id") String id, @RequestParam(name = "mode") Integer mode);

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @GetMapping("findDetailsById")
  ResponseModel findDetailsById(@RequestParam(name = "id") String id);
  /**
   * 数据字典导入日志记录
   * @return
   */
  @GetMapping("findAll")
  ResponseModel findAll();
}
