package com.bizunited.platform.dictionary.service.feign.fallback;


import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.service.feign.DictCategoryFeignClient;
import org.springframework.stereotype.Component;

/**
 * 字典分组服务的feign调用熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/20 10:16
 */
@Component
public class DictCategoryFeignClientFallback implements DictCategoryFeignClient {

  /**
   * 创建字典分类
   * @param dictCategoryVo
   * @param parentId
   * @return
   */
  @Override
  public ResponseModel create(DictCategoryVo dictCategoryVo, String parentId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改字典分类
   * @param dictCategoryVo
   * @return
   */
  @Override
  public ResponseModel update(DictCategoryVo dictCategoryVo) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 设置字典分类层级
   * @param childId
   * @param parentId
   * @return
   */
  @Override
  public ResponseModel bind(String childId, String parentId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据数据字典业务编号code进行查询，不包括任何关联信息
   * @param code
   * @return
   */
  @Override
  public ResponseModel findByCode(String code) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 查询所有字典分类
   * @return
   **/
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据id查询基本信息，没有任何关联信息
   * @param id
   * @return
   */
  @Override
  public ResponseModel findById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);

  }

  /**
   * 根据id查询字典分类的基本信息和关联信息（但是不包括字典分类的子级集合关联）
   * @param id
   * @return
   */
  @Override
  public ResponseModel findDetailsById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据分组id删除分组（不能删除有字典的分组）
   * @param id
   * @return
   */
  @Override
  public ResponseModel deleteById(String id) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }
}
