/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.feign.fallback.DictFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(qualifier="DictFeignClient", name="${dictionary.application.name}", path="/v1/nebula/dicts", fallback=DictFeignClientFallback.class, configuration={FeignRequestInterceptor.class})
public interface DictFeignClient {
    @GetMapping(value={"/findAll"})
    public ResponseModel findAll();

    @GetMapping(value={"/findByStatus"})
    public ResponseModel findByStatus(@RequestParam(name="dictStatus") Boolean var1);

    @GetMapping(value={"/findByConditions"})
    public ResponseModel findByConditions(@RequestParam(name="dictCode") String var1, @RequestParam(name="dictTitle") String var2, @RequestParam(name="dictType") String var3, @RequestParam(name="dictStatus") Boolean var4, @PageableDefault(value=50) Pageable var5);

    @PostMapping(value={""})
    public ResponseModel create(@RequestBody DictVo var1, @RequestParam(name="categoryId") String var2);

    @PatchMapping(value={""})
    public ResponseModel update(@RequestBody DictVo var1, @RequestParam(name="categoryId") String var2);

    @PostMapping(value={"/upgrade"})
    public ResponseModel upgrade(@RequestParam(name="newDictCode") String var1, @RequestParam(name="dictCode") String var2);

    @PatchMapping(value={"/update"})
    public ResponseModel update(@RequestParam(name="dictCode") String var1);

    @DeleteMapping(value={"/delete"})
    public ResponseModel delete(@RequestParam(name="dictCode") String var1);

    @GetMapping(value={"/findDetailsByIds"})
    public ResponseModel findDetailsByIds(@RequestParam(name="dictIds") String[] var1);

    @GetMapping(value={"/countByIds"})
    public ResponseModel countByIds(@RequestParam(name="ids") String[] var1);

    @GetMapping(value={"/findByDictCode"})
    public ResponseModel findByDictCode(@RequestParam(name="dictCode") String var1);

    @GetMapping(value={"/findDetailsByDictCode"})
    public ResponseModel findDetailsByDictCode(@RequestParam(name="dictCode") String var1);

    @GetMapping(value={"/findDetailsByDictCodes"})
    public ResponseModel findDetailsByDictCodes(@RequestParam(name="dictCodes") String[] var1);
}

