package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.service.feign.fallback.DictItemFeignClientFallback;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.Set;

/**
 * 数据字典项服务的feign调用
 * @Author: zengxingwang
 * @Date: 2020/3/20 10:16
 */
@FeignClient(qualifier = "DictItemFeignClient", name = "${dictionary.application.name}", path = "/v1/nebula/dictItems", fallback = DictItemFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface DictItemFeignClient {

  /**
   * 根据字典编码查询所有子项
   * @param dictCode
   * @return
   */
  @GetMapping("/findByCode")
  ResponseModel findByCode(@RequestParam(name = "dictCode") String dictCode);

  /**
   * 为字典类 修改/添加/删除 明细项
   * @param dictCode
   * @param items
   * @return
   */
  @PostMapping("/update")
  ResponseModel update(@RequestParam(name = "dictCode") String dictCode, @RequestBody Set<DictItemVo> items);

  /**
   * 根据字典ID启用字典
   * @param id
   * @return
   */
  @PutMapping("/enable")
  ResponseModel enable(@RequestParam("id") String id);

  /**
   * 根据字典ID禁用字典
   * @param id
   * @return
   */
  @PutMapping("/disable")
  ResponseModel disable(@RequestParam("id") String id);

  /**
   * 创建字典明细项(添加单个)
   * @param dictItem
   * @param dictCode
   * @return
   */
  @PostMapping("")
  ResponseModel create(@RequestBody DictItemVo dictItem, @RequestParam(name = "dictCode") String dictCode);

  /**
   * 根据id查询明细
   * @param id
   * @return
   */
  @GetMapping("/findDetailsById")
  ResponseModel findDetailsById(@RequestParam(name = "id") String id);

  /**
   * 根据字典dictCode和字典值的key查询一个数据字典值详细
   * @param dictCode,key
   * @return
   */
  @GetMapping("/findByKeyAndDictCode")
  ResponseModel findByKeyAndDictCode(@RequestParam(name = "dictCode") String dictCode, @RequestParam(name = "key") String key);
}
