package com.bizunited.platform.dictionary.service.feign.fallback;

import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.feign.DictFeignClient;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Component;

/**
 * 字典服务的feign调用熔断器
 * @Author: zengxingwang
 * @Date: 2020/3/20 10:16
 */
@Component
public class DictFeignClientFallback implements DictFeignClient {

  /**
   * 查询所有字典标题组
   */
  @Override
  public ResponseModel findAll() {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据启用状态查询字典
   * @param dictStatus
   * @return
   */
  @Override
  public ResponseModel findByStatus(Boolean dictStatus) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据字典的编号,类型,状态查询
   * @param dictCode
   * @param dictTitle
   * @param dictType
   * @param dictStatus
   * @param page
   * @param size
   * @return
   */
  @Override
  public ResponseModel findByConditions(String dictCode, String dictTitle, String dictType, Boolean dictStatus, int page, int size) {
    return new ResponseModel(System.currentTimeMillis(), Page.empty(PageRequest.of(page, size)), ResponseCode.E0, null);
  }

  /**
   * 创建字典类
   * @param dictVo
   * @param categoryId
   * @return
   */
  @Override
  public ResponseModel create(DictVo dictVo, String categoryId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 修改字典类
   * @param dictVo
   * @param categoryId
   * @return
   */
  @Override
  public ResponseModel update(DictVo dictVo, String categoryId) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 字典类复制升级
   * @param newDictCode
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel upgrade(String newDictCode, String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 上架字典
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel update(String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 删除某字典
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel delete(String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);
  }

  /**
   * 根据一个或者多个ID信息，查询字典明细信息，包括字典的各种关联信息（但是不包括下级关联信息）
   * @param dictIds
   * @return
   */
  @Override
  public ResponseModel findDetailsByIds(String[] dictIds) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);

  }

  /**
   * 按照指定的数据字典的ID信息，查询最终满足这些id编号的数据条目。
   * @param ids
   * @return
   */
  @Override
  public ResponseModel countByIds(String[] ids) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E703, null);

  }

  /**
   * 根据编码查询
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel findByDictCode(String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据编码查询（包括关联信息）
   * @param dictCode
   * @return
   */
  @Override
  public ResponseModel findDetailsByDictCode(String dictCode) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }

  /**
   * 根据编码批量查询（包括关联信息）
   * @param dictCodes
   * @return
   */
  @Override
  public ResponseModel findDetailsByDictCodes(String[] dictCodes) {
    return new ResponseModel(System.currentTimeMillis(), null, ResponseCode.E0, null);
  }
}
