package com.bizunited.platform.dictionary.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.dictionary.common.service.DictImportService;
import com.bizunited.platform.dictionary.common.vo.DictImportVo;
import com.bizunited.platform.dictionary.service.feign.DictImportFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

import java.util.List;

/**
 * 数据字典导入接口实现
 * @Author: zengxingwang
 * @Date: 2020/5/20 9:54
 */
@Service("DictImportServiceImpl")
public class DictImportServiceImpl implements DictImportService {

  @Autowired
  private DictImportFeignClient dictImportFeignClient;

  /**
   * 上传迁入文件
   * @param file
   * @return
   */
  @Override
  public DictImportVo upload(MultipartFile file) {
    ResponseModel response = dictImportFeignClient.upload(file);
    Validate.isTrue(response.getSuccess(), response.getErrorMsg());
    return JsonUtils.convert(response.getSuccessDataOrElse(null), DictImportVo.class);
  }

  /**
   * 数据字典导入执行
   * @param id
   * @param mode
   * @return
   */
  @Override
  public DictImportVo execute(String id, Integer mode) {
    ResponseModel response = dictImportFeignClient.execute(id, mode);
    return JsonUtils.convert(response.getSuccessDataOrElse(null), DictImportVo.class);
  }

  /**
   * 根据ID查询详情
   * @param id
   * @return
   */
  @Override
  public DictImportVo findDetailsById(String id) {
    ResponseModel response = dictImportFeignClient.findDetailsById(id);
    return JsonUtils.convert(response.getSuccessDataOrElse(null), DictImportVo.class);
  }
  /**
   * 查询导入日志
   * @return
   */
  @Override
  public List<DictImportVo> findAll() {
    ResponseModel response = dictImportFeignClient.findAll();
    return  JsonUtils.convert(response.getSuccessDataOrElse(Lists.newArrayList()), new TypeReference<List<DictImportVo>>() {});
  }
}
