/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.feign.service.internal;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.service.feign.DictItemFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="DictItemServiceImpl")
public class DictItemServiceImpl
implements DictItemService {
    @Autowired
    private DictItemFeignClient dictItemFeignClient;

    public List<DictItemVo> findItemsByCode(String dictCode) {
        ResponseModel response = this.dictItemFeignClient.findByCode(dictCode);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<DictItemVo>>(){});
    }

    public Set<DictItemVo> save(String dictCode, Set<DictItemVo> items) {
        ResponseModel response = this.dictItemFeignClient.update(dictCode, items);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<DictItemVo>>(){});
    }

    public DictItemVo enable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)"\u5b57\u5178\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictItemFeignClient.enable(dictItemId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictItemVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictItemVo.class);
    }

    public DictItemVo disable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)"\u5b57\u5178\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictItemFeignClient.disable(dictItemId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictItemVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictItemVo.class);
    }

    public DictItemVo create(String dictCode, DictItemVo dictItem) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Validate.notNull((Object)dictItem, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((dictItem.getId() == null ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u6570\u636eID\u5fc5\u987b\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictKey(), (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        ResponseModel response = this.dictItemFeignClient.create(dictItem, dictCode);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictItemVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictItemVo.class);
    }

    public DictItemVo findDetailsById(String id) {
        Validate.notNull((Object)id, (String)"\u67e5\u8be2\u5b57\u5178\u503c\u660e\u7ec6\u53c2\u6570\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        ResponseModel response = this.dictItemFeignClient.findDetailsById(id);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictItemVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictItemVo.class);
    }

    public DictItemVo findByKeyAndDictCode(String dictCode, String key) {
        if (StringUtils.isBlank((CharSequence)dictCode) || StringUtils.isBlank((CharSequence)key)) {
            return null;
        }
        ResponseModel response = this.dictItemFeignClient.findByKeyAndDictCode(dictCode, key);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictItemVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictItemVo.class);
    }
}

