/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.feign.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.JsonUtils;
import com.bizunited.platform.common.util.PageUtils;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.feign.DictFeignClient;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service(value="DictServiceImpl")
public class DictServiceImpl
implements DictService {
    @Autowired
    private DictFeignClient dictFeignClient;

    public List<DictVo> findAll() {
        ResponseModel response = this.dictFeignClient.findAll();
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<DictVo>>(){});
    }

    public List<DictVo> findByStatus(Boolean dictStatus) {
        ResponseModel response = this.dictFeignClient.findByStatus(dictStatus);
        return (List)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Lists.newArrayList()), (TypeReference)new TypeReference<List<DictVo>>(){});
    }

    public Page<DictVo> findByConditions(String dictCode, String dictTitle, String dictType, Boolean dictStatus, Pageable pageable) {
        ResponseModel response = this.dictFeignClient.findByConditions(dictCode, dictTitle, dictType, dictStatus, pageable.getPageNumber(), pageable.getPageSize());
        Object data = response.getSuccessDataOrElse(null);
        if (data == null) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return PageUtils.convert2Page((JSONObject)JsonUtils.toJSONObject((Object)data), (TypeReference)new TypeReference<List<DictVo>>(){});
    }

    public Set<DictVo> findDetailsByIds(String[] dictIds) {
        ResponseModel response = this.dictFeignClient.findDetailsByIds(dictIds);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<DictVo>>(){});
    }

    public int countByIds(String[] ids) {
        ResponseModel response = this.dictFeignClient.countByIds(ids);
        return (Integer)ObjectUtils.defaultIfNull((Object)response.getData(), (Object)0);
    }

    public DictVo create(DictVo dictVo, String categoryId) {
        Validate.notNull((Object)dictVo, (String)"\u8f93\u5165\u5b57\u5178\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictCode(), (String)"dict code \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictTitle(), (String)"dict title \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)categoryId, (String)"\u5b57\u5178\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictFeignClient.create(dictVo, categoryId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public DictVo update(DictVo dictVo, String categoryId) {
        Validate.notNull((Object)dictVo, (String)"\u8f93\u5165\u5b57\u5178\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictCode(), (String)"dict code \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictTitle(), (String)"dict title \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)categoryId, (String)"\u5b57\u5178\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictFeignClient.update(dictVo, categoryId);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public DictVo upgrade(String newDictCode, String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictFeignClient.upgrade(newDictCode, dictCode);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public DictVo onshelf(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictFeignClient.update(dictCode);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public void delete(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ResponseModel response = this.dictFeignClient.delete(dictCode);
        Validate.isTrue((boolean)response.getSuccess(), (String)response.getErrorMsg(), (Object[])new Object[0]);
    }

    public DictVo findByDictCode(String dictCode) {
        ResponseModel response = this.dictFeignClient.findByDictCode(dictCode);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public DictVo findDetailsByDictCode(String dictCode) {
        ResponseModel response = this.dictFeignClient.findDetailsByDictCode(dictCode);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public DictVo findDetailsByCodeAndStatus(String dictCode, Boolean showStatus) {
        ResponseModel response = this.dictFeignClient.findDetailsByCodeAndStatus(dictCode, showStatus);
        return (DictVo)JsonUtils.convert((Object)response.getSuccessDataOrElse(null), DictVo.class);
    }

    public void importData(MigrateImportModel importModel) {
        throw new UnsupportedOperationException("\u6682\u4e0d\u652f\u6301");
    }

    public Set<DictVo> findDetailsByDictCodes(String[] dictCodes) {
        ResponseModel response = this.dictFeignClient.findDetailsByDictCodes(dictCodes);
        return (Set)JsonUtils.convert((Object)response.getSuccessDataOrElse((Object)Sets.newHashSet()), (TypeReference)new TypeReference<Set<DictVo>>(){});
    }
}

