/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.service.feign.fallback.DictItemFeignClientFallback;
import java.util.Set;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

@FeignClient(qualifier="DictItemFeignClient", name="${dictionary.application.name}", path="/v1/nebula/dictItems", fallback=DictItemFeignClientFallback.class, configuration={FeignRequestInterceptor.class})
public interface DictItemFeignClient {
    @GetMapping(value={"/findByCode"})
    public ResponseModel findByCode(@RequestParam(name="dictCode") String var1);

    @PostMapping(value={"/update"})
    public ResponseModel update(@RequestParam(name="dictCode") String var1, @RequestBody Set<DictItemVo> var2);

    @PutMapping(value={"/enable"})
    public ResponseModel enable(@RequestParam(value="id") String var1);

    @PutMapping(value={"/disable"})
    public ResponseModel disable(@RequestParam(value="id") String var1);

    @PostMapping(value={""})
    public ResponseModel create(@RequestBody DictItemVo var1, @RequestParam(name="dictCode") String var2);

    @GetMapping(value={"/findDetailsById"})
    public ResponseModel findDetailsById(@RequestParam(name="id") String var1);

    @GetMapping(value={"/findByKeyAndDictCode"})
    public ResponseModel findByKeyAndDictCode(@RequestParam(name="dictCode") String var1, @RequestParam(name="key") String var2);

    @DeleteMapping(value={"/deleteByIds"})
    public ResponseModel deleteByIds(@RequestParam(name="ids") String[] var1);
}

