package com.bizunited.platform.dictionary.service.feign;

import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.common.interceptor.FeignRequestInterceptor;
import com.bizunited.platform.dictionary.service.feign.fallback.DictExportFeignClientFallback;
import feign.Response;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestParam;

/**
 * 数据字典导出feign调用
 * @Author: zengxingwang
 * @Date: 2020/5/21 14:10
 */
@FeignClient(qualifier = "DictExportFeignClient", name = "${dictionary.application.name}", path = "/v1/nebula/dictExport", fallback = DictExportFeignClientFallback.class, configuration = FeignRequestInterceptor.class)
public interface DictExportFeignClient {

  /**
   * 查询数据字典导出记录
   * @return
   */
  @GetMapping("findAll")
  ResponseModel findAll();

  /**
   * 导出数据字典
   * @param dictIds
   * @return
   */
  @GetMapping("/exportDict")
  Response exportDict(@RequestParam("dictIds") String[] dictIds);
}
