package com.bizunited.platform.dictionary.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 数据字典导出记录实体
 * @Author: zengxingwang
 * @Date: 2020/5/20 21:16
 */
@Entity
@ApiModel("数据迁移导出记录实体")
@Table(name = "engine_dict_export")
@org.hibernate.annotations.Table(appliesTo = "engine_dict_export", comment = "数据迁移导出记录")
public class DictExportEntity extends UuidEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 5955438707468887146L;

  /**
   * 创建者账号
   */
  @ApiModelProperty("创建者账号")
  @SaturnColumn(description = "创建者账号")
  @Column(name = "creator", nullable = false, columnDefinition = "varchar(255) COMMENT '创建者账号'")
  private String creator;

  /**
   * 创建时间
   */
  @ApiModelProperty("创建时间")
  @SaturnColumn(description = "创建时间")
  @Column(name = "create_time", nullable = false, columnDefinition = "datetime(3) COMMENT '创建时间'")
  private Date createTime;

  /**
   * 导出数据项，如果没有执行数据项，则表示导出所有数据
   */
  @ApiModelProperty("导出数据项")
  @SaturnColumn(description = "导出数据项")
  @Column(name = "datas", columnDefinition = "varchar(3000) COMMENT '导出数据项'")
  private String datas;

  /**
   * 创建用户
   */
  @Transient
  @ApiModelProperty("创建用户")
  @SaturnColumn(description = "创建用户")
  private UserVo createUser;

  public String getCreator() {
    return creator;
  }

  public void setCreator(String creator) {
    this.creator = creator;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public String getDatas() {
    return datas;
  }

  public void setDatas(String datas) {
    this.datas = datas;
  }

  public UserVo getCreateUser() {
    return createUser;
  }

  public void setCreateUser(UserVo createUser) {
    this.createUser = createUser;
  }
}
