package com.bizunited.platform.dictionary.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToOne;
import javax.persistence.Table;

/**
 * 数据字典数据的导出导入详情
 * @Author: zengxingwang
 * @Date: 2020/5/19 18:40
 */
@Entity
@ApiModel("迁入文件保存实体")
@Table(name = "engine_dict_import_detail")
@org.hibernate.annotations.Table(appliesTo = "engine_dict_import_detail", comment = "数据字典数据的导出导入详情")
public class DictImportDetailEntity extends UuidEntity {

  /**
   * 
   */
  private static final long serialVersionUID = 8966530736184199607L;

  /**
   * 导入记录
   */
  @ApiModelProperty("导入记录")
  @SaturnColumn(description = "导入记录")
  @OneToOne(fetch = FetchType.LAZY, mappedBy = "detail")
  private DictImportEntity dictImport;

  /**
   * 新增的条数
   */
  @ApiModelProperty("新增的条数")
  @SaturnColumn(description = "新增的条数")
  @Column(name = "create_count", nullable = false, columnDefinition = "int(11) COMMENT '新增的条数'")
  private Integer createCount;

  /**
   * 更新的条数
   */
  @ApiModelProperty("更新的条数")
  @SaturnColumn(description = "更新的条数")
  @Column(name = "update_count", nullable = false, columnDefinition = "int(11) COMMENT '更新的条数'")
  private Integer updateCount;

  /**
   * 忽略的条数
   */
  @ApiModelProperty("忽略的条数")
  @SaturnColumn(description = "忽略的条数")
  @Column(name = "ignore_count", nullable = false, columnDefinition = "int(11) COMMENT '忽略的条数'")
  private Integer ignoreCount;

  /**
   * 总条数
   */
  @ApiModelProperty("总条数")
  @SaturnColumn(description = "总条数")
  @Column(name = "total_count", nullable = false, columnDefinition = "int(11) COMMENT '总条数'")
  private Integer totalCount;

  /**
   * 执行日志
   */
  @ApiModelProperty("执行日志")
  @SaturnColumn(description = "执行日志")
  @Column(name = "execute_log", nullable = false, columnDefinition = "text(0) COMMENT '执行日志'")
  private String executeLog;

  public DictImportEntity getMigrateImport() {
    return dictImport;
  }

  public void setMigrateImport(DictImportEntity migrateImport) {
    this.dictImport = migrateImport;
  }

  public Integer getCreateCount() {
    return createCount;
  }

  public void setCreateCount(Integer createCount) {
    this.createCount = createCount;
  }

  public Integer getUpdateCount() {
    return updateCount;
  }

  public void setUpdateCount(Integer updateCount) {
    this.updateCount = updateCount;
  }

  public Integer getTotalCount() {
    return totalCount;
  }

  public void setTotalCount(Integer totalCount) {
    this.totalCount = totalCount;
  }

  public String getExecuteLog() {
    return executeLog;
  }

  public void setExecuteLog(String executeLog) {
    this.executeLog = executeLog;
  }

  public Integer getIgnoreCount() {
    return ignoreCount;
  }

  public void setIgnoreCount(Integer ignoreCount) {
    this.ignoreCount = ignoreCount;
  }
}
