package com.bizunited.platform.dictionary.service.local.repository;


import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.repository.internal.DictRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Set;

/**
 * DictRepository
 *
 * @description:
 * @author: yanwe
 * @date: 11/Feb/2019 10:22
 */
@Repository("DictRepository")
public interface DictRepository extends JpaRepository<DictEntity, String>, JpaSpecificationExecutor<DictEntity>, DictRepositoryCustom {

  /**
   * 根据字典启用状态查询
   *
   * @param dictStatus
   * @return
   */
  List<DictEntity> findByDictStatus(Boolean dictStatus);
  /**
   * 根据字典类型编号查询字典集合
   * @param dictCode
   * @return
   */
  @Query("from DictEntity de "
          + " left join fetch de.category dec "
          + " where de.dictCode = :dictCode")
  DictEntity findDetailsByDictCode(@Param("dictCode") String dictCode);
  /**
   * 根据一个或者多个ID信息，查询字典明细信息，包括字典的各种关联信息
   * @param dictIds
   * @return
   */
  @Query("from DictEntity de "
      + " left join fetch de.category dec "
      + " left join fetch de.dictItems "
      + " where de.id in (:dictIds)")
  Set<DictEntity> findDetailsByIds(@Param("dictIds") String[] dictIds);
  /**
   * 按照指定的数据字典的ID信息，查询最终满足这些id编号的数据条目。<br>
   * 这个方法一般用于验证一批给定的id，是否都能在系统中找到对应的数据
   * @param ids 指定的id信息
   * @return 满足的条目数量将会被返回
   */
  @Query(value="select count(id) from engine_dict where engine_dict.id in (:ids)" , nativeQuery = true)
  int countByIds(@Param("ids") String[] ids);

  /**
   * 根据编码查询
   * @param dictCode
   * @return
   */
  DictEntity findByDictCode(@Param("dictCode") String dictCode);
}
