package com.bizunited.platform.dictionary.service.local.service.init;


import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.dictionary.service.local.entity.DictCategoryEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictCategoryRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictItemRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.Date;

import static com.bizunited.platform.common.constant.Constants.DEFAULT_ADMIN_ACCOUNT;;

/**
 * 系统初始化时增加组织机构枚举类
 * @Author: TanBoQiuYun
 * @Date: 2019/12/2 14:14
 */
@Component("DictionaryInitProcess")
public class DictionaryInitProcess implements InitProcessService {
  
  private static final String BASE_CONFIG_CODE = "baseConfig";
  private static final String BASE_CONFIG_NAME = "基础配置";
  private static final String DICT_CODE = "orgType";
  private static final String DICT_TYPE = "通用型";
  private static final String DICT_TITLE = "组织机构类型";
  private static final String INT = "int";
  @Autowired
  private DictCategoryRepository dictCategoryRepository;
  @Autowired
  private DictRepository dictRepository;
  @Autowired
  private DictItemRepository dictItemRepository;

  @Override
  public int sort() {
    // 初始化动作靠前
    return 5;
  }

  /**
   * 只有返回true才进行初始化动作
   * @return
   */
  @Override
  public boolean doProcess() {
    //如果字典分类里面存在基础配置字符串分类，在engine_dict有dict_code为orType的数据就初始化
    return this.dictCategoryRepository.findByCateCode(BASE_CONFIG_CODE) == null
            || this.dictRepository.findByDictCode(DICT_CODE) == null;
  }

  @Override
  public boolean stopOnException() {
    // 一旦出现异常，则终止进程启动过程
    return true;
  }

  @Override
  public void init() {
    //根据分类编码查询是否存在，不存在就初始化
    DictCategoryEntity categoryEntity = this.dictCategoryRepository.findByCateCode(BASE_CONFIG_CODE);
    DictEntity dictEntity = this.dictRepository.findByDictCode(DICT_CODE);
    //如果categoryEntity为null，dictEntity不为null的情况怎么处理呢？不予处理
    if (categoryEntity == null && dictEntity == null){
      categoryEntity = this.initOrganizationDictCategory();
      //传递父级
      dictEntity = this.initOrganizationDict(categoryEntity);
      this.initOrganizationDictItem(dictEntity);
    }else if (categoryEntity != null && dictEntity == null){
      dictEntity = this.initOrganizationDict(categoryEntity);
      this.initOrganizationDictItem(dictEntity);
    }
  }


  /**
   * 初始化数据字典值，同时设置父级
   * @param dictEntity 父级
   */
  private void initOrganizationDictItem(DictEntity dictEntity) {
    DictItemEntity itemEntity = new DictItemEntity();
    Date nowDate = new Date();
    itemEntity.setDictKey("部门");
    itemEntity.setDictValue("0");
    itemEntity.setDictItemStatus(Boolean.TRUE);
    itemEntity.setDictEntity(dictEntity);
    itemEntity.setCreateTime(nowDate);
    dictItemRepository.save(itemEntity);

    DictItemEntity dictItemEntity = new DictItemEntity();
    dictItemEntity.setDictKey("单位");
    dictItemEntity.setDictValue("1");
    dictItemEntity.setDictItemStatus(Boolean.TRUE);
    dictItemEntity.setDictEntity(dictEntity);
    dictItemEntity.setCreateTime(nowDate);
    dictItemRepository.save(dictItemEntity);
  }


  /**
   * 初始化数据字典子分类engine_dict,同时设置父级
   * @param categoryEntity 父级
   * @return
   */
  private DictEntity initOrganizationDict(DictCategoryEntity categoryEntity) {
    DictEntity dictEntity = new DictEntity();
    // 新增字典默认明细项数量为0
    dictEntity.setItemNum(2);
    // 默认启用状态为TRUE
    dictEntity.setDictStatus(Boolean.TRUE);
    dictEntity.setDictCode(DICT_CODE);
    dictEntity.setDictTitle(DICT_TITLE);
    dictEntity.setDictType(DICT_TYPE);
    dictEntity.setCategory(categoryEntity);
    dictEntity.setCreateTime(new Date());
    dictEntity.setModifyTime(new Date());
    dictEntity.setValueType(INT);
    return this.dictRepository.saveAndFlush(dictEntity);
  }

  /**
   * 初始化字典分类表
   * @return
   */
  private DictCategoryEntity initOrganizationDictCategory() {
    DictCategoryEntity categoryEntity = new DictCategoryEntity();
    categoryEntity.setCreateTime(new Date());
    categoryEntity.setModifyTime(new Date());

    categoryEntity.setCateName(BASE_CONFIG_NAME);
    categoryEntity.setCateCode(BASE_CONFIG_CODE);
    categoryEntity.setCreateAccount(DEFAULT_ADMIN_ACCOUNT);
    categoryEntity.setModifyAccount(DEFAULT_ADMIN_ACCOUNT);
    return this.dictCategoryRepository.saveAndFlush(categoryEntity);
  }

}
