/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.internal;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictItemRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DictItemServiceImpl")
public class DictItemServiceImpl
implements DictItemService {
    private static final String ERROR_MESS = "\u5b57\u5178\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;

    public List<DictItemVo> findItemsByCode(String dictCode) {
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        if (dictEntity == null) {
            return Lists.newArrayList();
        }
        List<DictItemEntity> dictItems = this.dictItemRepository.findByDictEntityOrderByDictSort(dictEntity);
        Collection dictItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictItems, DictItemEntity.class, DictItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Lists.newArrayList((Iterable)dictItemVos);
    }

    @Transactional
    public Set<DictItemVo> save(String dictCode, Set<DictItemVo> items) {
        HashMap<String, DictItemVo> map = new HashMap<String, DictItemVo>();
        for (DictItemVo dictItemVo : items) {
            map.put(dictItemVo.getDictValue(), dictItemVo);
        }
        DictVo dict = this.dictService.findDetailsByDictCode(dictCode);
        Validate.notNull((Object)dict, (String)"\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01", (Object[])new Object[0]);
        DictEntity entity = (DictEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dict, DictEntity.class, HashSet.class, ArrayList.class, new String[0]));
        List<DictItemEntity> dictItemsList = this.dictItemRepository.findByDictEntity(entity);
        if (items == null) {
            items = new HashSet<DictItemVo>();
        }
        this.saveValidation(dictCode, items, dictItemsList);
        HashSet needInsertDictItems = new HashSet();
        HashSet needUpdateDictItems = new HashSet();
        HashSet needDeleteDictItems = new HashSet();
        Collection dictItemEntities = this.nebulaToolkitService.copyCollectionByWhiteList(items, DictItemVo.class, DictItemEntity.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.nebulaToolkitService.collectionDiscrepancy(dictItemEntities, dictItemsList, DictItemEntity::getDictValue, needDeleteDictItems, needUpdateDictItems, needInsertDictItems);
        int itemNum = CollectionUtils.isEmpty(needUpdateDictItems) ? items.size() + dictItemsList.size() : items.size() - needUpdateDictItems.size() + dictItemsList.size();
        dict.setItemNum(Integer.valueOf(itemNum));
        dict.setDictItems(null);
        DictEntity dictEntity = (DictEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dict, DictEntity.class, HashSet.class, ArrayList.class, new String[]{"category"}));
        this.dictRepository.saveAndFlush((Object)dictEntity);
        this.dictItemRepository.flush();
        needInsertDictItems.stream().forEach(dictItem -> {
            dictItem.setId(null);
            dictItem.setCreateTime(new Date());
            dictItem.setDictSort(dictItem.getDictSort() == null ? 1 : dictItem.getDictSort());
            dictItem.setDictEntity(dictEntity);
            dictItem.setDictItemStatus(dictItem.getDictItemStatus() == null ? Boolean.TRUE : dictItem.getDictItemStatus());
        });
        this.dictItemRepository.saveAll(needInsertDictItems);
        for (DictItemEntity dictItem2 : needUpdateDictItems) {
            DictItemVo mapItem = (DictItemVo)map.get(dictItem2.getDictValue());
            dictItem2.setDictItemStatus(mapItem.getDictItemStatus());
            dictItem2.setDictKey(mapItem.getDictKey());
            dictItem2.setDictSort(mapItem.getDictSort());
            this.dictItemRepository.save((Object)dictItem2);
        }
        Collection dictItemVos = this.nebulaToolkitService.copyCollectionByWhiteList(needInsertDictItems, DictItemEntity.class, DictItemVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return Sets.newLinkedHashSet((Iterable)dictItemVos);
    }

    @Transactional
    public DictItemVo create(String dictCode, DictItemVo dictItem) {
        this.createValidation(dictCode, dictItem);
        DictVo dict = this.dictService.findByDictCode(dictCode);
        dict.setItemNum(Integer.valueOf(dict.getItemNum() + 1));
        DictEntity dictEntity = (DictEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dict, DictEntity.class, HashSet.class, ArrayList.class, new String[0]));
        this.dictRepository.save((Object)dictEntity);
        DictItemEntity dictItemEntity = (DictItemEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictItem, DictItemEntity.class, HashSet.class, ArrayList.class, new String[0]));
        dictItemEntity.setCreateTime(new Date());
        dictItemEntity.setDictSort(dictItem.getDictSort() == null ? 1 : dictItem.getDictSort());
        dictItemEntity.setDictEntity(dictEntity);
        dictItemEntity.setDictItemStatus(dictItem.getDictItemStatus() == null ? Boolean.TRUE : dictItem.getDictItemStatus());
        DictItemEntity entity = (DictItemEntity)((Object)this.dictItemRepository.save((Object)dictItemEntity));
        return (DictItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void createValidation(String dictCode, DictItemVo dictItem) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        DictVo dict = this.dictService.findByDictCode(dictCode);
        Validate.notNull((Object)dict, (String)"\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dictItem, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.isTrue((dictItem.getId() == null ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u6570\u636eID\u5fc5\u987b\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictKey(), (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItem.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        long countByDictKey = this.dictItemRepository.countByDictKeyAndDictId(dictItem.getDictKey(), dict.getId());
        Validate.isTrue((countByDictKey == 0L ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        long countByDictValue = this.dictItemRepository.countByDictValueAndDictId(dictItem.getDictValue(), dict.getId());
        Validate.isTrue((countByDictValue == 0L ? 1 : 0) != 0, (String)"\u5b57\u5178\u503c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Transactional
    public DictItemVo enable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)((Object)dictItemEntity), (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(true);
        DictItemEntity dictItem = (DictItemEntity)((Object)this.dictItemRepository.save((Object)dictItemEntity));
        return (DictItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictItem, DictItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public DictItemVo disable(String dictItemId) {
        Validate.notBlank((CharSequence)dictItemId, (String)ERROR_MESS, (Object[])new Object[0]);
        DictItemEntity dictItemEntity = this.dictItemRepository.findDetailById(dictItemId);
        Validate.notNull((Object)((Object)dictItemEntity), (String)ERROR_MESS, (Object[])new Object[0]);
        dictItemEntity.setDictItemStatus(false);
        DictItemEntity dictItem = (DictItemEntity)((Object)this.dictItemRepository.save((Object)dictItemEntity));
        return (DictItemVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictItem, DictItemVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    private void saveValidation(String dictCode, Set<DictItemVo> items, List<DictItemEntity> dictItemsList) {
        Validate.notBlank((CharSequence)dictCode, (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        Collection dictItemCollection = this.nebulaToolkitService.copyCollectionByWhiteList(dictItemsList, DictItemEntity.class, DictItemEntity.class, HashSet.class, ArrayList.class, new String[0]);
        ArrayList oldItems = Lists.newArrayList((Iterable)dictItemCollection);
        HashSet needInsertItems = new HashSet();
        Collection dictItems = this.nebulaToolkitService.copyCollectionByWhiteList(items, DictItemVo.class, DictItemEntity.class, HashSet.class, ArrayList.class, new String[0]);
        needInsertItems.addAll(dictItems);
        Map<String, DictItemEntity> oldItemsMap = oldItems.stream().collect(Collectors.toMap(DictItemEntity::getDictValue, e -> e));
        dictItems.forEach(item -> {
            DictItemEntity dictItemEntity = (DictItemEntity)((Object)((Object)oldItemsMap.get(item.getDictValue())));
            if (null != dictItemEntity) {
                needInsertItems.remove(item);
                dictItemEntity.setDictKey(item.getDictKey());
            }
        });
        HashSet dictItemValues = new HashSet();
        HashSet dictItemKeys = new HashSet();
        dictItems.forEach(item -> {
            Validate.notNull((Object)item, (String)"\u4fdd\u5b58\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getDictKey(), (String)"\u5b57\u5178\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)item.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((!dictItemValues.contains(item.getDictValue()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u503c\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            Validate.isTrue((!dictItemKeys.contains(item.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            dictItemValues.add(item.getDictValue());
            dictItemKeys.add(item.getDictKey());
        });
        needInsertItems.addAll(oldItems);
        HashSet dbDictItemKeys = new HashSet();
        needInsertItems.forEach(item -> {
            Validate.isTrue((!dbDictItemKeys.contains(item.getDictKey()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u540d\u79f0\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
            dbDictItemKeys.add(item.getDictKey());
        });
    }
}

