/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.init;

import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.service.dictCategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.local.repository.DictItemRepository;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="DictionaryInitProcess")
public class DictionaryInitProcess
implements InitProcessService {
    private Logger LOGGER = LoggerFactory.getLogger(DictionaryInitProcess.class);
    private static final String INIT_FILE_PATH = "classpath:".concat("initjsons/dicts.json");
    @Autowired
    private DictCategoryService dictCategoryService;
    @Autowired
    private DictService dictService;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private DictItemRepository dictItemRepository;

    public int sort() {
        return 5;
    }

    public boolean doProcess() {
        return true;
    }

    public boolean stopOnException() {
        return true;
    }

    public void init() {
        Resource resource = this.applicationContext.getResource(INIT_FILE_PATH);
        try (InputStream inputStream = resource.getInputStream();){
            int line;
            StringBuilder sb = new StringBuilder();
            byte[] buffer = new byte[512];
            while ((line = inputStream.read(buffer, 0, buffer.length)) != -1) {
                sb.append(new String(buffer, 0, line, StandardCharsets.UTF_8));
            }
            String json = sb.toString();
            if (StringUtils.isBlank((CharSequence)json)) {
                this.LOGGER.warn("\u521d\u59cb\u5316\u6570\u636e\u5b57\u5178json\u4e3a\u7a7a\uff01\uff01");
                return;
            }
            List dictCategoryVos = JSONArray.parseArray((String)json, DictCategoryVo.class);
            if (CollectionUtils.isEmpty((Collection)dictCategoryVos)) {
                return;
            }
            dictCategoryVos.forEach(dictCategoryVo -> this.initDictCategory((DictCategoryVo)dictCategoryVo));
        }
        catch (IOException e) {
            this.LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void initDictCategory(DictCategoryVo dictCategoryVo) {
        if (dictCategoryVo == null) {
            return;
        }
        DictCategoryVo categoryVo = this.dictCategoryService.findByCode(dictCategoryVo.getCateCode());
        if (categoryVo == null) {
            dictCategoryVo.setCreateAccount("admin");
            dictCategoryVo.setModifyAccount("admin");
            categoryVo = this.dictCategoryService.create(dictCategoryVo, null);
        }
        this.initDict(dictCategoryVo.getDicts(), categoryVo.getId());
    }

    private void initDict(Set<DictVo> dicts, String categoryId) {
        if (CollectionUtils.isEmpty(dicts)) {
            return;
        }
        dicts.forEach(dictVo -> {
            DictVo oldDict = this.dictService.findByDictCode(dictVo.getDictCode());
            if (oldDict == null) {
                this.dictService.create(dictVo, categoryId);
            } else {
                dictVo.setId(oldDict.getId());
                this.initDictItem(dictVo.getDictItems(), (DictVo)dictVo);
            }
        });
    }

    private void initDictItem(Set<DictItemVo> dictItems, DictVo dictVo) {
        if (CollectionUtils.isEmpty(dictItems)) {
            return;
        }
        dictItems.forEach(item -> {
            long dictKeyCount = this.dictItemRepository.countByDictKeyAndDictId(item.getDictKey(), dictVo.getId());
            long dictValueCount = this.dictItemRepository.countByDictValueAndDictId(item.getDictValue(), dictVo.getId());
            if (dictKeyCount == 0L && dictValueCount == 0L) {
                this.dictItemService.create(dictVo.getDictCode(), item);
            }
        });
    }
}

