/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ChineseCharUtils;
import com.bizunited.platform.dictionary.common.service.dictCategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.service.local.entity.DictCategoryEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictCategoryRepository;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.vo.UserVo;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DictCategoryServiceImpl")
public class DictCategoryServiceImpl
implements DictCategoryService {
    @Autowired
    private DictCategoryRepository dictCategoryRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Transactional
    public DictCategoryVo create(DictCategoryVo dictCategoryVo, String parentId) {
        Validate.notNull((Object)dictCategoryVo, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)dictCategoryVo.getId()), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictCategoryVo.getCateName(), (String)"\u5b57\u5178\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictCategoryVo.getCateCode(), (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((!ChineseCharUtils.hasChinese((String)dictCategoryVo.getCateCode()) ? 1 : 0) != 0, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u542b\u6709\u4e2d\u6587\uff01", (Object[])new Object[0]);
        DictCategoryEntity existCode = this.dictCategoryRepository.findByCateCode(dictCategoryVo.getCateCode());
        Validate.isTrue((null == existCode ? 1 : 0) != 0, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        if (StringUtils.isBlank((CharSequence)dictCategoryVo.getCreateAccount()) || StringUtils.isBlank((CharSequence)dictCategoryVo.getModifyAccount())) {
            UserVo user = SecurityUtils.getCurrentUser();
            dictCategoryVo.setCreateAccount(user.getAccount());
            dictCategoryVo.setModifyAccount(user.getAccount());
        }
        DictCategoryEntity entity = (DictCategoryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setCreateTime(new Date());
        entity.setModifyTime(new Date());
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            Optional op = this.dictCategoryRepository.findById(parentId);
            DictCategoryEntity parent = op.orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u67e5\u8be2\u5230\u4f20\u5165\u7236\u7c7b\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
            entity.setParentCategory(parent);
        }
        entity.setProjectName(this.platformContext.getAppName());
        DictCategoryEntity dictCategory = (DictCategoryEntity)((Object)this.dictCategoryRepository.saveAndFlush((Object)entity));
        return (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public DictCategoryVo update(DictCategoryVo entity) {
        Validate.notNull((Object)entity, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getId(), (String)"\u65b0\u589e\u65f6\u4e0d\u80fd\u586b\u5165Id!", (Object[])new Object[0]);
        Optional op = this.dictCategoryRepository.findById(entity.getId());
        DictCategoryEntity existId = op.orElse(null);
        Validate.notNull((Object)((Object)existId), (String)"\u672a\u67e5\u8be2\u5230\u5f53\u524d\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)entity.getCateName(), (String)"\u5b57\u5178\u5206\u7c7b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserVo user = SecurityUtils.getCurrentUser();
        existId.setCateName(entity.getCateName());
        existId.setCateDesc(entity.getCateDesc());
        if (entity.getParentCategory() != null) {
            Optional opDictCategory = this.dictCategoryRepository.findById(entity.getParentCategory().getId());
            DictCategoryEntity parent = opDictCategory.orElse(null);
            Validate.notNull((Object)((Object)parent), (String)"\u672a\u67e5\u8be2\u5230\u4f20\u5165\u7236\u7c7b\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
            existId.setParentCategory(parent);
        } else {
            existId.setParentCategory(null);
        }
        existId.setModifyTime(new Date());
        existId.setModifyAccount(user.getAccount());
        DictCategoryEntity dictCategory = (DictCategoryEntity)((Object)this.dictCategoryRepository.save((Object)existId));
        return (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public void bind(String childId, String parentId) {
        Validate.notBlank((CharSequence)childId, (String)"\u5b50\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Optional op = this.dictCategoryRepository.findById(childId);
        DictCategoryEntity child = op.orElse(null);
        Validate.notNull((Object)((Object)child), (String)"\u672a\u67e5\u8be2\u5230\u5b50\u7ea7\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
        child.setParentCategory(null);
        if (StringUtils.isNotEmpty((CharSequence)parentId)) {
            Validate.notBlank((CharSequence)parentId, (String)"\u7236\u7ea7\u5b57\u5178\u5206\u7c7bID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
            Optional optional = this.dictCategoryRepository.findById(parentId);
            Validate.isTrue((boolean)optional.isPresent(), (String)"\u672a\u67e5\u8be2\u5230\u7236\u7ea7\u5b57\u5178\u5206\u7c7b\uff01", (Object[])new Object[0]);
            DictCategoryEntity parent = (DictCategoryEntity)((Object)optional.get());
            child.setParentCategory(parent);
        }
        this.dictCategoryRepository.saveAndFlush((Object)child);
    }

    public DictCategoryVo findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.dictCategoryRepository.findById(id);
        DictCategoryEntity dictCategory = op.orElse(null);
        return (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    public DictCategoryVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DictCategoryEntity dictCategory = this.dictCategoryRepository.findDetailsById(id);
        return (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[]{"parentCategory"});
    }

    public DictCategoryVo findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        DictCategoryEntity dictCategory = this.dictCategoryRepository.findByCateCode(code);
        if (dictCategory == null) {
            return null;
        }
        return (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u5b57\u5178\u5206\u7c7bid\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        DictCategoryEntity dictCategory = this.dictCategoryRepository.findById(id).orElse(null);
        if (dictCategory == null) {
            return;
        }
        this.isExistDicts(dictCategory);
        this.dictCategoryRepository.delete((Object)dictCategory);
    }

    private void isExistDicts(DictCategoryEntity dictCategory) {
        Validate.isTrue((boolean)CollectionUtils.isEmpty(dictCategory.getDicts()), (String)"\u5b57\u5178\u5206\u7ec4\u4e0b\u5b58\u5728\u5b57\u5178\uff0c\u4e0d\u80fd\u5220\u9664", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(dictCategory.getChildCategory())) {
            return;
        }
        for (DictCategoryEntity child : dictCategory.getChildCategory()) {
            this.isExistDicts(child);
            this.dictCategoryRepository.delete((Object)child);
        }
    }

    public Set<DictCategoryVo> findAll() {
        LinkedHashSet<DictCategoryVo> dictCategoryVos = new LinkedHashSet<DictCategoryVo>();
        Set<DictCategoryEntity> dictCategorys = this.dictCategoryRepository.findByTreeAndProjectName(this.platformContext.getAppName());
        for (DictCategoryEntity dictCategory : dictCategorys) {
            DictCategoryVo dictCategoryVo = (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictCategory, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[]{"dicts", "dicts.dictItems"});
            dictCategoryVo.setChildCategory(this.findChildren(dictCategory));
            dictCategoryVos.add(dictCategoryVo);
        }
        return dictCategoryVos;
    }

    public Set<DictCategoryVo> findChildren(DictCategoryEntity dictCategory) {
        LinkedHashSet<DictCategoryVo> dictCategoryVos = new LinkedHashSet<DictCategoryVo>();
        Set<DictCategoryEntity> children = dictCategory.getChildCategory();
        if (CollectionUtils.isEmpty(children)) {
            return Sets.newHashSet();
        }
        for (DictCategoryEntity child : children) {
            DictCategoryVo dictCategoryVo = (DictCategoryVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)child, DictCategoryVo.class, HashSet.class, ArrayList.class, new String[]{"dicts", "dicts.dictItems"});
            dictCategoryVo.setChildCategory(this.findChildren(child));
            dictCategoryVos.add(dictCategoryVo);
        }
        return dictCategoryVos;
    }

    public String importCategory(String id, Map<String, DictCategoryVo> dictCategoryMap) {
        DictCategoryVo category = dictCategoryMap.get(id);
        String categoryId = null;
        Validate.notNull((Object)category, (String)"\u5bfc\u5165\u6570\u636e\u5b57\u5178\u672a\u627e\u5230\u5206\u7c7b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        DictCategoryEntity dictCategory = this.dictCategoryRepository.findByCateCode(category.getCateCode());
        if (dictCategory == null) {
            category.setId(null);
            DictCategoryVo dictCategoryVo = this.create(category, null);
            categoryId = dictCategoryVo.getId();
            category.setId(dictCategoryVo.getId());
            this.hanldParent(category, dictCategoryMap);
        } else {
            categoryId = dictCategory.getId();
        }
        return categoryId;
    }

    private void hanldParent(DictCategoryVo dictCategoryVo, Map<String, DictCategoryVo> dictCategoryMap) {
        if (dictCategoryVo.getParentCategory() == null) {
            return;
        }
        String parentcategoryId = dictCategoryVo.getParentCategory().getId();
        DictCategoryVo category = dictCategoryMap.get(parentcategoryId);
        DictCategoryEntity dictCategory = this.dictCategoryRepository.findByCateCode(category.getCateCode());
        if (dictCategory == null) {
            category.setId(null);
            DictCategoryVo dictCategoryParent = this.create(category, null);
            this.dictCategoryRepository.updateParentId(dictCategoryVo.getId(), dictCategoryParent.getId());
            category.setId(dictCategoryParent.getId());
            this.hanldParent(category, dictCategoryMap);
        } else {
            this.dictCategoryRepository.updateParentId(dictCategoryVo.getId(), dictCategory.getId());
        }
    }
}

