/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.repository.internal.DictRepositoryCustom;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="DictRepositoryImpl")
public class DictRepositoryImpl
implements DictRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;
    private static final String DICT_CODE = "dictCode";
    private static final String DICT_TITLE = "dictTitle";
    private static final String DICT_STATUS = "dictStatus";
    private static final String DICT_TYPE = "dictType";

    @Override
    public Page<DictEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object dictType;
        Object dictStatus;
        Object dictTitle;
        String hql = "from DictEntity u  where 1 = 1";
        String countHql = "select count(*) from DictEntity u where 1 = 1";
        hql = hql + " and u.projectName=:projectName ";
        countHql = countHql + " and u.projectName=:projectName ";
        Object dictCode = conditions.get(DICT_CODE);
        if (dictCode != null) {
            hql = hql + " AND u.dictCode = :dictCode ";
            countHql = countHql + " AND u.dictCode = :dictCode ";
        }
        if ((dictTitle = conditions.get(DICT_TITLE)) != null) {
            hql = hql + " AND u.dictTitle = :dictTitle ";
            countHql = countHql + " AND u.dictTitle = :dictTitle ";
        }
        if ((dictStatus = conditions.get(DICT_STATUS)) != null) {
            hql = hql + " AND u.dictStatus = :dictStatus ";
            countHql = countHql + " AND u.dictStatus = :dictStatus ";
        }
        if ((dictType = conditions.get(DICT_TYPE)) != null) {
            hql = hql + " AND u.dictType = :dictType ";
            countHql = countHql + " AND u.dictType = :dictType ";
        }
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createQuery(countHql);
        query.setParameter("projectName", (Object)this.platformContext.getAppName());
        countQuery.setParameter("projectName", (Object)this.platformContext.getAppName());
        if (dictCode != null) {
            query.setParameter(DICT_CODE, dictCode);
            countQuery.setParameter(DICT_CODE, dictCode);
        }
        if (dictTitle != null) {
            query.setParameter(DICT_TITLE, dictTitle);
            countQuery.setParameter(DICT_TITLE, dictTitle);
        }
        if (dictStatus != null) {
            query.setParameter(DICT_STATUS, dictStatus);
            countQuery.setParameter(DICT_STATUS, dictStatus);
        }
        if (dictType != null) {
            query.setParameter(DICT_TYPE, dictType);
            countQuery.setParameter(DICT_TYPE, dictType);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List results = query.getResultList();
        long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(results, pageable, count);
    }

    @Override
    public DictEntity findDetailsByCodeAndStatus(String dictCode, Boolean status) {
        StringBuilder hql = new StringBuilder("from DictEntity de left join fetch de.category dec left join fetch de.dictItems items where 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)dictCode)) {
            hql.append(" AND de.dictCode = :dictCode ");
        }
        if (status != null) {
            hql.append(" AND items.dictItemStatus = :status ");
        }
        hql.append(" order by items.dictItemStatus ");
        Query query = this.entityManager.createQuery(hql.toString());
        if (StringUtils.isNotBlank((CharSequence)dictCode)) {
            query.setParameter(DICT_CODE, (Object)dictCode);
        }
        if (status != null) {
            query.setParameter("status", (Object)status);
        }
        return (DictEntity)((Object)query.getSingleResult());
    }
}

