/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.service.dictCategory.DictCategoryService;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictCategoryVo;
import com.bizunited.platform.dictionary.common.vo.DictVo;
import com.bizunited.platform.dictionary.service.local.entity.DictCategoryEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictItemRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictRepository;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="dictServiceImpl")
public class DictServiceImpl
implements DictService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictServiceImpl.class);
    private static final String ERROR_CODE_MESS = "\u67e5\u8be2\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01";
    private static final String ERROR_MESS = "\u672a\u627e\u5230\u8be5\u7f16\u7801\u5339\u914d\u5b57\u5178\uff01";
    @Autowired
    private DictRepository dictRepository;
    @Autowired
    private DictItemRepository dictItemRepository;
    @Autowired
    private DictCategoryService dictCategoryService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private PlatformContext platformContext;

    public List<DictVo> findAll() {
        List dictEntities = this.dictRepository.findAll();
        if (!CollectionUtils.isEmpty((Collection)dictEntities)) {
            dictEntities = dictEntities.stream().filter(dictEntity -> StringUtils.equals((CharSequence)this.platformContext.getAppName(), (CharSequence)dictEntity.getProjectName())).collect(Collectors.toList());
        }
        Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<DictVo>(dictVos);
    }

    public List<DictVo> findByStatus(Boolean dictStatus) {
        List<DictEntity> dictEntities = this.dictRepository.findByDictStatusAndProjectName(dictStatus, this.platformContext.getAppName());
        Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new ArrayList<DictVo>(dictVos);
    }

    public Page<DictVo> findByConditions(String dictCode, String dictTitle, String dictType, Boolean dictStatus, Pageable pageable) {
        HashMap<String, Object> conditions = new HashMap<String, Object>();
        if (StringUtils.isNotBlank((CharSequence)dictCode)) {
            conditions.put("dictCode", dictCode);
        }
        if (StringUtils.isNotBlank((CharSequence)dictTitle)) {
            conditions.put("dictTitle", dictTitle);
        }
        if (StringUtils.isNotBlank((CharSequence)dictType)) {
            conditions.put("dictType", dictType);
        }
        if (dictStatus != null) {
            conditions.put("dictStatus", dictStatus);
        }
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        Page page = this.dictRepository.queryPage(pageable, conditions);
        Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)page.getContent(), DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        return new PageImpl(new ArrayList(dictVos), page.getPageable(), page.getTotalElements());
    }

    public DictVo findDetailsByCodeAndStatus(String dictCode, Boolean showStatus) {
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        DictEntity entity = this.dictRepository.findDetailsByCodeAndStatus(dictCode, showStatus);
        if (entity == null) {
            return null;
        }
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictVo.class, HashSet.class, ArrayList.class, new String[]{"category", "dictItems"});
    }

    public Set<DictVo> findDetailsByIds(String[] dictIds) {
        if (dictIds == null || dictIds.length == 0) {
            return Sets.newHashSet();
        }
        Set<DictEntity> dictEntities = this.dictRepository.findDetailsByIds(dictIds);
        Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(dictEntities, DictEntity.class, DictVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"category", "dictItems"});
        return Sets.newLinkedHashSet((Iterable)dictVos);
    }

    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.dictRepository.countByIds(ids);
    }

    @Transactional
    public DictVo create(DictVo dictVo, String categoryId) {
        this.validEntity(dictVo, categoryId);
        DictCategoryVo categoryVo = this.dictCategoryService.findById(categoryId);
        DictEntity existDict = this.dictRepository.findByDictCode(dictVo.getDictCode());
        Validate.isTrue((null == existDict ? 1 : 0) != 0, (String)"\u8be5\u7f16\u7801\u5df2\u6709\u91cd\u590d\uff01", (Object[])new Object[0]);
        DictEntity dictEntity = (DictEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictVo, DictEntity.class, HashSet.class, ArrayList.class, new String[0]));
        dictEntity.setItemNum(0);
        dictEntity.setDictStatus(true);
        DictCategoryEntity categoryEntity = (DictCategoryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class, new String[0]));
        dictEntity.setCategory(categoryEntity);
        dictEntity.setCreateTime(new Date());
        dictEntity.setModifyTime(new Date());
        dictEntity.setProjectName(this.platformContext.getAppName());
        DictEntity dict = (DictEntity)((Object)this.dictRepository.saveAndFlush((Object)dictEntity));
        this.dictItemService.save(dictEntity.getDictCode(), dictVo.getDictItems());
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dict, DictVo.class, HashSet.class, ArrayList.class, new String[]{"dictItems"});
    }

    @Transactional
    public DictVo update(DictVo dictVo, String categoryId) {
        this.validEntity(dictVo, categoryId);
        DictCategoryVo categoryVo = this.dictCategoryService.findById(categoryId);
        Optional op = this.dictRepository.findById(dictVo.getId());
        DictEntity existDict = op.orElse(null);
        Validate.notNull((Object)((Object)existDict), (String)"\u8be5\u5b57\u5178\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)existDict), (String)"\u672a\u627e\u5230\u6539\u4fee\u6539\u5b57\u5178", (Object[])new Object[0]);
        existDict.setDescription(dictVo.getDescription());
        existDict.setDictType(dictVo.getDictType());
        existDict.setDictTitle(dictVo.getDictTitle());
        DictCategoryEntity categoryEntity = (DictCategoryEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)categoryVo, DictCategoryEntity.class, HashSet.class, ArrayList.class, new String[0]));
        existDict.setCategory(categoryEntity);
        existDict.setModifyTime(new Date());
        existDict.setValueType(dictVo.getValueType());
        Set dictItems = dictVo.getDictItems();
        this.dictItemService.save(dictVo.getDictCode(), dictItems);
        DictEntity entity = (DictEntity)((Object)this.dictRepository.saveAndFlush((Object)existDict));
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public DictVo upgrade(String newDictCode, String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)((Object)dictEntity), (String)ERROR_MESS, (Object[])new Object[0]);
        DictEntity newDict = new DictEntity();
        newDict.setDictCode(newDictCode);
        newDict.setDictTitle(dictEntity.getDictTitle());
        newDict.setItemNum(dictEntity.getItemNum());
        newDict.setDescription(dictEntity.getDescription());
        newDict.setDictType(dictEntity.getDictType());
        newDict.setDictStatus(false);
        newDict.setDictItems(new HashSet<DictItemEntity>());
        newDict.setCategory(dictEntity.getCategory());
        newDict.setCreateTime(new Date());
        newDict.setModifyTime(new Date());
        newDict.setProjectName(this.platformContext.getAppName());
        newDict = (DictEntity)((Object)this.dictRepository.saveAndFlush((Object)newDict));
        HashSet<DictItemEntity> newItems = new HashSet<DictItemEntity>();
        for (DictItemEntity item : dictEntity.getDictItems()) {
            DictItemEntity newItem = new DictItemEntity();
            newItem.setDictSort(item.getDictSort());
            newItem.setDictKey(item.getDictKey());
            newItem.setDictValue(item.getDictValue());
            newItem.setDictEntity(newDict);
            newItem.setCreateTime(new Date());
            newItem.setProjectName(this.platformContext.getAppName());
            newItems.add(newItem);
        }
        this.dictItemRepository.saveAll(newItems);
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)newDict, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public DictVo onshelf(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)((Object)dictEntity), (String)ERROR_MESS, (Object[])new Object[0]);
        dictEntity.setDictStatus(true);
        DictEntity entity = (DictEntity)((Object)this.dictRepository.saveAndFlush((Object)dictEntity));
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
    }

    @Transactional
    public void delete(String dictCode) {
        Validate.notBlank((CharSequence)dictCode, (String)ERROR_CODE_MESS, (Object[])new Object[0]);
        DictEntity dictEntity = this.dictRepository.findByDictCode(dictCode);
        Validate.notNull((Object)((Object)dictEntity), (String)ERROR_MESS, (Object[])new Object[0]);
        Validate.isTrue((dictEntity.getDictStatus() == false ? 1 : 0) != 0, (String)"\u5df2\u4e0a\u67b6\u7684\u5b57\u5178\u65e0\u6cd5\u5220\u9664\uff01", (Object[])new Object[0]);
        Set<DictItemEntity> dictItemEntities = dictEntity.getDictItems();
        this.dictItemRepository.deleteAll(dictItemEntities);
        this.dictRepository.delete((Object)dictEntity);
    }

    public DictVo findByDictCode(String dictCode) {
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        DictEntity entity = this.dictRepository.findByDictCode(dictCode);
        if (entity == null) {
            return null;
        }
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictVo.class, HashSet.class, ArrayList.class, new String[]{"category"});
    }

    public DictVo findDetailsByDictCode(String dictCode) {
        if (StringUtils.isBlank((CharSequence)dictCode)) {
            return null;
        }
        DictEntity entity = this.dictRepository.findDetailsByDictCode(dictCode);
        if (entity == null) {
            return null;
        }
        return (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"category", "dictItems"});
    }

    public Set<DictVo> findDetailsByDictCodes(String[] dictCodes) {
        if (dictCodes == null || dictCodes.length == 0) {
            return null;
        }
        Set<DictEntity> entities = this.dictRepository.findDetailsByDictCodes(dictCodes);
        Collection dictVos = this.nebulaToolkitService.copyCollectionByWhiteList(entities, DictEntity.class, DictVo.class, HashSet.class, ArrayList.class, new String[]{"category", "dictItems"});
        return Sets.newLinkedHashSet((Iterable)dictVos);
    }

    private void validEntity(DictVo dictVo, String categoryId) {
        Validate.notNull((Object)dictVo, (String)"\u8f93\u5165\u5b57\u5178\u4e0d\u53ef\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictCode(), (String)"dict code \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getDictTitle(), (String)"dict title \u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)categoryId, (String)"\u5b57\u5178\u5206\u7ec4ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictVo.getValueType(), (String)"\u5b57\u5178\u503c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        DictCategoryVo categoryVo = this.dictCategoryService.findById(categoryId);
        Validate.notNull((Object)categoryVo, (String)"\u672a\u67e5\u8be2\u5230\u5b57\u5178\u5206\u7ec4", (Object[])new Object[0]);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry dataViewEntry = zipFile.getEntry("dict.in");
        if (dataViewEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
        }
        if (dataViewEntry != null) {
            try (InputStream is = zipFile.getInputStream(dataViewEntry);
                 ObjectInputStream ois = new ObjectInputStream(is);){
                List dictCategorys = (List)ois.readObject();
                List dicts = (List)ois.readObject();
                if (CollectionUtils.isEmpty((Collection)dicts)) {
                    importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a");
                } else {
                    this.importData(dicts, dictCategorys, importModel);
                }
            }
            catch (IOException | ClassNotFoundException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                importModel.append("\u8bfb\u53d6\u4e1a\u52a1\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
            }
        }
    }

    private void importData(List<DictVo> dicts, List<DictCategoryVo> dictCategorys, MigrateImportModel importModel) {
        importModel.setTotalCount(dicts.size());
        Map<String, DictCategoryVo> dictCategoryMap = this.getDictCategoryMapById(dictCategorys);
        for (int i = 0; i < dicts.size(); ++i) {
            DictVo dict = dicts.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(dict, importModel, dictCategoryMap);
        }
    }

    private Map<String, DictCategoryVo> getDictCategoryMapById(List<DictCategoryVo> dictCategorys) {
        HashMap<String, DictCategoryVo> dictCategoryMap = new HashMap<String, DictCategoryVo>();
        for (DictCategoryVo dictCategoryVo : dictCategorys) {
            dictCategoryMap.put(dictCategoryVo.getId(), dictCategoryVo);
        }
        return dictCategoryMap;
    }

    private void importData(DictVo dict, MigrateImportModel importModel, Map<String, DictCategoryVo> dictCategoryMap) {
        importModel.append("\u5f00\u59cb\u5904\u7406\u6570\u636e\uff1a").appendLine(dict.getDictTitle());
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        DictEntity dbDict = this.dictRepository.findByDictCode(dict.getDictCode());
        this.handleImportDataId(dict);
        if (dbDict != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6570\u636e\u5b57\u5178\u5df2\u5b58\u5728\uff0c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbDict != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6570\u636e\u5b57\u5178\u5df2\u5b58\u5728\uff0c\u8fdb\u884c\u66f4\u65b0\u8986\u76d6");
            this.handleUpdateData(dict, dbDict, importModel);
            return;
        }
        if (dbDict == null) {
            this.handleCreateData(dict, dbDict, importModel, dictCategoryMap);
            return;
        }
        importModel.appendLine("\u6682\u4e0d\u652f\u6301\u7684\u6267\u884c\u65b9\u5f0f");
        importModel.addSkipCount();
    }

    private void handleCreateData(DictVo dict, DictEntity dbDict, MigrateImportModel importModel, Map<String, DictCategoryVo> dictCategoryMap) {
        importModel.appendLine("\u5f00\u59cb\u65b0\u589e\u6570\u636e\u5b57\u5178");
        importModel.appendLine("\u5bfc\u5165\u6570\u636e\u5b57\u5178");
        String ategoryId = this.dictCategoryService.importCategory(dict.getCategory().getId(), dictCategoryMap);
        this.create(dict, ategoryId);
        importModel.addCreateCount();
    }

    private void handleUpdateData(DictVo dict, DictEntity dbDict, MigrateImportModel importModel) {
        DictVo dictVo = (DictVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dbDict, DictVo.class, HashSet.class, ArrayList.class, new String[0]);
        dictVo.setDictTitle(dict.getDictTitle());
        dictVo.setDescription(dict.getDescription());
        dictVo.setDictType(dict.getDictType());
        dictVo.setValueType(dict.getValueType());
        dictVo.setDictItems(dict.getDictItems());
        this.update(dictVo, dbDict.getCategory().getId());
        importModel.appendLine("\u66f4\u65b0\u6210\u529f");
        importModel.addUpdateCount();
    }

    private void handleImportDataId(DictVo dict) {
        dict.setId(null);
        Set dictItems = dict.getDictItems();
        if (!CollectionUtils.isEmpty((Collection)dictItems)) {
            dictItems.forEach(f -> f.setId(null));
        }
    }
}

