package com.bizunited.platform.dictionary.service.local.annotations;

import com.bizunited.platform.dictionary.service.local.configuration.DictionaryLocalServiceAutoConfiguration;
import org.springframework.context.annotation.Import;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service可以启动dictionary本地文件服务
 * @author paul chan
 * @date 2020-03-16 10:14
 */
@Retention(value = java.lang.annotation.RetentionPolicy.RUNTIME)
@Target(value = { java.lang.annotation.ElementType.TYPE })
@Documented
@Import({DictionaryLocalServiceAutoConfiguration.class})
public @interface EnableDictionaryLocalService {

}
