package com.bizunited.platform.dictionary.service.local.repository;

import com.bizunited.platform.dictionary.service.local.entity.DictCategoryEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * DictCategoryRepository
 *
 * @description:
 * @author: yanwe
 * @date: 11/Jun/2019 17:26
 */
@Repository("DictCategoryRepository")
public interface DictCategoryRepository extends JpaSpecificationExecutor<DictCategoryEntity>, JpaRepository<DictCategoryEntity,String> {

  /**
   * 根据名称查询（名字唯一）
   * @param cateCode
   * @return
   */
  DictCategoryEntity findByCateCode(String cateCode);
  /**
   * 根据id查询字典分类的基本信息和关联信息（但是不包括字典分类的子级集合关联）
   * @param id
   * @return
   */
  @Query("from DictCategoryEntity dc "
      + " left join fetch dc.parentCategory dcp "
      + " where dc.id = :id ")
  DictCategoryEntity findDetailsById(@Param("id") String id);
  /**
   * 树级结构查询，查询包括字典分组，字典分组下的字典，不包括字典明细数据
   * @return
   */
  @Query(value = "select dce from DictCategoryEntity dce "
      + " left join dce.childCategory "
      + " left join dce.dicts "
      + " where dce.parentCategory = null and dce.projectName= :projectName order by dce.createTime ")
  Set<DictCategoryEntity> findByTreeAndProjectName(@Param("projectName") String projectName);

  /**
   * 根据名称查询（名字唯一）
   * @param CateName
   * @return
   */
  DictCategoryEntity findByCateNameAndProjectName(String CateName, String projectName);

  /**
   * 更新上级id
   * @param id
   * @param parentId
   */
  @Modifying
  @Query(value = "update engine_category_dict set parent_id = :parentId where id = :id", nativeQuery = true)
  void updateParentId(@Param("id") String id, @Param("parentId") String parentId);
}