package com.bizunited.platform.dictionary.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderBy;
import javax.persistence.Table;
import java.util.Date;
import java.util.Set;

/**
 * DictEntity
 * @description:
 * @author: yanwe
 * @date: 13/Feb/2019 10:20
 */
@ApiModel(value = "DictEntity", description = "字典")
@Entity
@Table(name = "engine_dict")
@org.hibernate.annotations.Table(appliesTo = "engine_dict" , comment = "字典")
public class DictEntity extends UuidEntity {

  private static final long serialVersionUID = 7649043001002183691L;

  /** 字典的类型编号. * */
  @Column(name = "dict_code", length = 64, nullable = false, unique = true, columnDefinition = "varchar(64) COMMENT '字典的类型编号'")
  @ApiModelProperty(name = "dictCode", value = "字典类型编号", required = true)
  @SaturnColumn(description = "字典类型编号")
  private String dictCode;

  /** 字典的标题. * */
  @Column(name = "dict_title", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '字典的标题'")
  @ApiModelProperty(name = "dictTitle", value = "字典的标题", required = true)
  @SaturnColumn(description = "字典的标题")
  private String dictTitle;

  /** 字典的运营范围,先固定值为 通用/业务. * */
  @Column(name = "dict_type", length = 64, nullable = false, columnDefinition = "varchar(64) COMMENT '字典的运营范围,先固定值为 通用/业务'")
  @ApiModelProperty(name = "dictType", value = "字典的运营范围,先固定值为 通用/业务", required = true)
  @SaturnColumn(description = "字典的运营范围,先固定值为 通用/业务")
  private String dictType;

  /** 父级分组 */
  @ManyToOne(fetch = FetchType.LAZY)
  @JoinColumn(name = "category_id", columnDefinition = "varchar(255) COMMENT '父级分组'")
  @SaturnColumn(description = "父级分类")
  private DictCategoryEntity category;

  /** 字典明细数量. * */
  @Column(name = "item_num", nullable = false, columnDefinition = "int(11) COMMENT '字典明细数量'")
  @ApiModelProperty(name = "itemNum", value = "字典明细数量", required = true)
  @SaturnColumn(description = "字典明细数量")
  private Integer itemNum;

  /** 字典的说明. * */
  @Column(name = "description" , columnDefinition = "varchar(255) COMMENT '字典的说明'")
  @ApiModelProperty(name = "description", value = "字典说明")
  @SaturnColumn(description = "字典说明")
  private String description;

  /** 字典的启用状态 */
  @Column(name = "dict_status", columnDefinition = "bit(1) COMMENT '字典的启用状态'")
  @ApiModelProperty(name = "dictStatus", value = "字典启用状态")
  @SaturnColumn(description = "字典启用状态")
  private Boolean dictStatus;

  @OrderBy("dictSort")
  @OneToMany(fetch = FetchType.LAZY, mappedBy = "dictEntity")
  @SaturnColumn(description = "字典明细")
  private Set<DictItemEntity> dictItems;

  /** 创建时间 */
  @ApiModelProperty(name = "createTime", value = "创建时间", required = true)
  @Column(name = "create_time" , columnDefinition = "datetime COMMENT '创建时间'")
  @SaturnColumn(description = "创建时间")
  private Date createTime;

  /** 最后更新时间 */
  @ApiModelProperty(name = "modifyTime", value = "最后更新时间", required = true)
  @Column(name = "modify_time" , columnDefinition = "datetime COMMENT '最后更新时间'")
  @SaturnColumn(description = "最后更新时间")
  private Date modifyTime;

  /** 值类型 */
  @ApiModelProperty(name = "valueType", value = "值类型", required = true)
  @Column(name = "value_type" , nullable = false, columnDefinition = "varchar(255) COMMENT '值类型'")
  @SaturnColumn(description = "值类型")
  private String valueType;

  /** 当前项目名工程名*/
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName = ApplicationContextUtils.getProjectName();

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }
  public String getValueType() {
    return valueType;
  }

  public void setValueType(String valueType) {
    this.valueType = valueType;
  }

  public String getDictCode() {
    return dictCode;
  }

  public void setDictCode(String dictCode) {
    this.dictCode = dictCode;
  }

  public String getDictTitle() {
    return dictTitle;
  }

  public void setDictTitle(String dictTitle) {
    this.dictTitle = dictTitle;
  }

  public Integer getItemNum() {
    return itemNum;
  }

  public void setItemNum(Integer itemNum) {
    this.itemNum = itemNum;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Boolean getDictStatus() {
    return dictStatus;
  }

  public void setDictStatus(Boolean dictStatus) {
    this.dictStatus = dictStatus;
  }

  public Set<DictItemEntity> getDictItems() {
    return dictItems;
  }

  public void setDictItems(Set<DictItemEntity> dictItems) {
    this.dictItems = dictItems;
  }

  public DictCategoryEntity getCategory() {
    return category;
  }

  public void setCategory(DictCategoryEntity category) {
    this.category = category;
  }

  public String getDictType() {
    return dictType;
  }

  public void setDictType(String dictType) {
    this.dictType = dictType;
  }

  public Date getCreateTime() {
    return createTime;
  }

  public void setCreateTime(Date createTime) {
    this.createTime = createTime;
  }

  public Date getModifyTime() {
    return modifyTime;
  }

  public void setModifyTime(Date modifyTime) {
    this.modifyTime = modifyTime;
  }
}
