package com.bizunited.platform.dictionary.service.local.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

/**
 * 描述业务系统中的组织机构和数据字典值关系
 */
@Entity
@ApiModel(value = "DictItemOrgMappingEntity", description = "组织机构和数据字典值关系")
@Table(name = "engine_dict_item_org_mapping", uniqueConstraints = @UniqueConstraint(columnNames = {"dict_item", "org_code"}))
@org.hibernate.annotations.Table(appliesTo = "engine_dict_item_org_mapping", comment = "组织机构和数据字典值关系")
public class DictItemOrgMappingEntity extends UuidEntity {
  /**
   * 
   */
  private static final long serialVersionUID = -863115908998028434L;

  /**
   * 数据字典值
   */
  @ApiModelProperty("数据字典值")
  @ManyToOne(fetch = FetchType.LAZY)
  @SaturnColumn(description="数据字典值")
  @JoinColumn(name = "dict_item", nullable = false, referencedColumnName = "id", columnDefinition = "varchar(64) COMMENT '数据字典值id'")
  private DictItemEntity dictItem;

  /**
   * 组织机构编码
   */
  @ApiModelProperty("组织机构编码")
  @SaturnColumn(description="组织机构编码")
  @Column(name = "org_code", nullable = false, columnDefinition = "varchar(128) COMMENT '组织机构编码'")
  private String orgCode;

  public DictItemEntity getDictItem() {
    return dictItem;
  }

  public void setDictItem(DictItemEntity dictItem) {
    this.dictItem = dictItem;
  }

  public String getOrgCode() {
    return orgCode;
  }

  public void setOrgCode(String orgCode) {
    this.orgCode = orgCode;
  }
}
