package com.bizunited.platform.dictionary.service.local.repository.internal;

import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.dictionary.service.local.entity.DictItemOrgMappingEntity;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DictItemOrgMappingRepositoryImpl implements DictItemOrgMappingRepositoryCustom, PageRepositoryImpl {

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;

  @SuppressWarnings("unchecked")
  @Override
  public Page<DictItemOrgMappingEntity> findByConditions(Map<String, Object> parameters, Pageable pageable) {
    StringBuilder hql = new StringBuilder("select ediom.id, ediom.dict_item, ediom.org_code from engine_organization_extend eoe " +
        " LEFT JOIN engine_org eo on eoe.organization_id = eo.id  " +
        " LEFT JOIN engine_dict_item_org_mapping ediom on ediom.org_code = eo.org_code  " +
        " LEFT JOIN engine_dict_item edi on edi.id = ediom.dict_item where eoe.is_delete = 0 ");
    StringBuilder countHql = new StringBuilder("select count(ediom.org_code) from engine_organization_extend eoe " +
        " LEFT JOIN engine_org eo on eoe.organization_id = eo.id  " +
        " LEFT JOIN engine_dict_item_org_mapping ediom on ediom.org_code = eo.org_code " +
        " LEFT JOIN engine_dict_item edi on edi.id = ediom.dict_item where eoe.is_delete = 0 ");
    Map<String, Object> parameter = new HashMap<>();
    String id = (String) parameters.get("id");
    if (StringUtils.isNotBlank(id)) {
      hql.append(" AND eo.id = :id");
      hql.append(" or eo.parent_id = :id");
      countHql.append(" AND eo.id = :id");
      countHql.append(" or eo.parent_id = :id");
      parameter.put("id", id);
    }
    String code = (String) parameters.get("code");
    if (StringUtils.isNotBlank(code)) {
      hql.append(" AND eo.code = :code");
      countHql.append(" AND eo.code = :code");
      parameter.put("code", code);
    }
    String orgName = (String) parameters.get("orgName");
    if (StringUtils.isNotBlank(orgName)) {
      hql.append(" AND eo.org_Name like CONCAT('%',:orgName,'%')");
      countHql.append(" AND eo.org_Name like CONCAT('%',:orgName,'%')");
      parameter.put("orgName", orgName);
    }
    Integer tstatus = (Integer) parameters.get("tstatus");
    if (tstatus != null) {
      hql.append(" AND eo.tstatus = :tstatus");
      countHql.append(" AND eo.tstatus = :tstatus");
      parameter.put("tstatus", tstatus);
    }
    String dictValue = (String) parameters.get("dictValue");
    if (StringUtils.isNotBlank(dictValue)) {
      hql.append(" AND edi.dict_value like CONCAT('%',:dictValue,'%')");
      countHql.append(" AND edi.dict_value like CONCAT('%',:dictValue,'%')");
      parameter.put("dictValue", dictValue);
    }
    Integer dictSort = (Integer) parameters.get("dictSort");
    if (dictSort != null) {
      hql.append(" AND edi.dict_sort = :dictSort");
      countHql.append(" AND edi.dict_sort= :dictSort");
      parameter.put("dictSort", dictSort - 1);
    }
    hql.append(" order by edi.dict_sort, eo.create_time");
    Query query = entityManager.createNativeQuery(hql.toString(), DictItemOrgMappingEntity.class);
    Query countQuery = entityManager.createNativeQuery(countHql.toString());
    parameter.forEach((k, v) -> {
      query.setParameter(k, v);
      countQuery.setParameter(k, v);
    });

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<DictItemOrgMappingEntity> results = query.getResultList();

    // 查询总数量信息
    long count = Integer.parseInt(String.valueOf(countQuery.getResultList().get(0)));
    return new PageImpl<>(results, pageable, count);
  }

  @SuppressWarnings("unchecked")
  @Override
  public List<DictItemOrgMappingEntity> findOrgByConditions(Map<String, Object> parameters) {
    StringBuilder hql = new StringBuilder("select ediom.id, ediom.dict_item, ediom.org_code from engine_organization_extend eoe " +
        " LEFT JOIN engine_org eo on eoe.organization_id = eo.id  " +
        "LEFT JOIN engine_dict_item_org_mapping ediom on ediom.org_code = eo.org_code  " +
        "LEFT JOIN engine_dict_item edi on edi.id = ediom.dict_item where eoe.is_delete = 0 ");
    Map<String, Object> parameter = new HashMap<>();
    Integer value = (Integer) parameters.get("dictValue");
    String name = (String) parameters.get("name");
    if (value != null) {
      hql.append(" AND edi.dict_value = :value");
      parameter.put("value", value);
    }
    if (StringUtils.isNotBlank(name)) {
      hql.append(" AND eo.org_name like CONCAT('%',:name,'%')");
      parameter.put("name", name);
    }
    hql.append(" order by eo.create_time");
    Query query = entityManager.createNativeQuery(hql.toString(), DictItemOrgMappingEntity.class);
    parameter.forEach(query::setParameter);
    return query.getResultList();
  }
}
