package com.bizunited.platform.dictionary.service.local.repository.internal;

import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.dictionary.service.local.entity.DictEntity;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import java.util.List;
import java.util.Map;

/**
 * DictRepositoryImpl
 *
 * @description:
 * @author: yanwe
 * @date: 11/Feb/2019 10:25
 */
@Repository("DictRepositoryImpl")
public class DictRepositoryImpl implements DictRepositoryCustom {
  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  private static final String DICT_CODE = "dictCode";
  private static final String DICT_TITLE = "dictTitle";
  private static final String DICT_STATUS = "dictStatus";
  private static final String DICT_TYPE = "dictType";

  @Override
  @SuppressWarnings("unchecked")
  public Page<DictEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    /*
     * 按照需求，是按照编码，标题，状态进行查询
      **/
    String hql = "from DictEntity u  where 1 = 1";
    String countHql = "select count(*) from DictEntity u where 1 = 1";
    //筛选项目名称
    hql += " and u.projectName=:projectName ";
    countHql += " and u.projectName=:projectName ";
    Object dictCode = conditions.get(DICT_CODE);
    if(dictCode != null) {
      hql += " AND u.dictCode = :dictCode ";
      countHql += " AND u.dictCode = :dictCode ";
    }
    Object dictTitle = conditions.get(DICT_TITLE);
    if(dictTitle != null) {
      hql += " AND u.dictTitle = :dictTitle ";
      countHql += " AND u.dictTitle = :dictTitle ";
    }
    Object dictStatus = conditions.get(DICT_STATUS);
    if (dictStatus != null) {
      hql += " AND u.dictStatus = :dictStatus ";
      countHql += " AND u.dictStatus = :dictStatus ";
    }

    Object dictType = conditions.get(DICT_TYPE);
    if (dictType != null) {
      hql += " AND u.dictType = :dictType ";
      countHql += " AND u.dictType = :dictType ";
    }

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countHql);
    query.setParameter("projectName", ApplicationContextUtils.getProjectName());
    countQuery.setParameter("projectName", ApplicationContextUtils.getProjectName());
    if(dictCode != null) {
      query.setParameter(DICT_CODE, dictCode);
      countQuery.setParameter(DICT_CODE, dictCode);
    }
    if(dictTitle != null) {
      query.setParameter(DICT_TITLE, dictTitle);
      countQuery.setParameter(DICT_TITLE, dictTitle);
    }
    if (dictStatus != null) {
      query.setParameter(DICT_STATUS, dictStatus);
      countQuery.setParameter(DICT_STATUS, dictStatus);
    }
    if (dictType != null) {
      query.setParameter(DICT_TYPE, dictType);
      countQuery.setParameter(DICT_TYPE, dictType);
    }

    // 构造分页信息
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<DictEntity> results = query.getResultList();

    // 查询总数量信息
    long count = (long)countQuery.getResultList().get(0);
    return new PageImpl<>(results,pageable,count);
  }
}