/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.internal;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ApplicationContextUtils;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.dictionary.common.service.DictImportService;
import com.bizunited.platform.dictionary.common.service.dict.DictService;
import com.bizunited.platform.dictionary.common.vo.DictImportVo;
import com.bizunited.platform.dictionary.service.local.entity.DictImportDetailEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictImportEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictImportDetailRepository;
import com.bizunited.platform.dictionary.service.local.repository.DictImportRepository;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="DictImportServiceImpl")
public class DictImportServiceImpl
implements DictImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(DictImportServiceImpl.class);
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;
    @Autowired
    private DictImportRepository dictImportRepository;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private DictImportDetailRepository dictImportDetailRepository;
    @Autowired
    private DictService dictService;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private UserService userService;

    @Transactional
    public DictImportVo upload(MultipartFile file) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        UserVo user = SecurityUtils.getCurrentUser();
        DictImportEntity dictImport = new DictImportEntity();
        dictImport.setCreateTime(new Date());
        dictImport.setExecuted(false);
        dictImport.setCreator(user.getAccount());
        dictImport.setOriginalFileName(file.getOriginalFilename());
        Object[] files = new MultipartFile[]{file};
        List ordinaryFileEntities = this.fileUpdateService.fileUpload("migrate", user.getAccount(), null, (MultipartFile[])files);
        Validate.notEmpty((Object[])files, (String)"\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        OrdinaryFileVo fileEntity = (OrdinaryFileVo)ordinaryFileEntities.get(0);
        Validate.notNull((Object)fileEntity, (String)"\u4e0a\u6b21\u6587\u4ef6\u4fdd\u5b58\u8fd4\u56de\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dictImport.setFileName(fileEntity.getFileName());
        dictImport.setRelativeLocal(fileEntity.getRelativeLocal());
        DictImportEntity dictImportEntity = this.create(dictImport);
        return (DictImportVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictImportEntity, DictImportVo.class, HashSet.class, ArrayList.class, new String[]{"creator", "executor"});
    }

    private DictImportEntity create(DictImportEntity dictImport) {
        Validate.notNull((Object)dictImport.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictImport.getRelativeLocal(), (String)"\u8fc1\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictImport.getFileName(), (String)"\u8fc1\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dictImport.getCreator(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dictImport.getCreateTime(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dictImport.getExecuted(), (String)"\u8fc1\u5165\u6587\u4ef6\u4efb\u52a1\u662f\u5426\u88ab\u6267\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        dictImport.setProjectName(ApplicationContextUtils.getProjectName());
        return (DictImportEntity)((Object)this.dictImportRepository.save((Object)dictImport));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transactional
    public DictImportVo execute(String id, Integer mode) {
        ImportExecuteModeEnum executeMode;
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (mode == null) {
            executeMode = ImportExecuteModeEnum.SKIP;
        } else {
            executeMode = ImportExecuteModeEnum.valueOfMode((int)mode);
            Validate.notNull((Object)executeMode, (String)"\u4e0d\u652f\u6301\u7684\u6267\u884c\u6a21\u5f0f\uff1a%s", (Object[])new Object[]{mode});
        }
        UserVo user = SecurityUtils.getCurrentUser();
        DictImportEntity dictImport = this.dictImportRepository.findDetailsById(id);
        Validate.notNull((Object)((Object)dictImport), (String)"\u672a\u627e\u5230\u5bfc\u5165\u7684\u8bb0\u5f55", (Object[])new Object[0]);
        Validate.isTrue((dictImport.getExecuted() == false ? 1 : 0) != 0, (String)"\u8be5\u5bfc\u5165\u5df2\u7ecf\u6267\u884c\u8fc7\u4e86\uff01\uff01", (Object[])new Object[0]);
        byte[] bytes = this.venusFileService.readFileContent(dictImport.getRelativeLocal(), dictImport.getFileName());
        DictImportDetailEntity importDetail = dictImport.getDetail();
        if (importDetail == null) {
            importDetail = new DictImportDetailEntity();
        }
        Validate.isTrue((bytes != null && bytes.length > 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        File tmpFile = FileUtils.writeLocalFile((byte[])bytes, (String)this.fileRoot, (String)"zip");
        int executeResult = NormalStatusEnum.ENABLE.getStatus();
        try (ZipFile zipFile = new ZipFile(tmpFile);){
            MigrateImportModel importModel = new MigrateImportModel(zipFile, executeMode);
            try {
                this.dictService.importData(importModel);
                importModel.appendLine("\u5bfc\u5165\u5b8c\u6210\uff01");
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                importModel.setError(true);
                importModel.append("\u5bfc\u5165\u9519\u8bef\uff1a").appendLine(e.getMessage());
            }
            finally {
                importDetail.setCreateCount(importModel.getCreateCount());
                importDetail.setIgnoreCount(importModel.getSkipCount());
                importDetail.setTotalCount(importModel.getTotalCount());
                importDetail.setUpdateCount(importModel.getUpdateCount());
                importDetail.setExecuteLog(importModel.getExecuteLog().toString());
                if (importModel.isError()) {
                    executeResult = NormalStatusEnum.DISABLE.getStatus();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u51fa\u9519\uff1a%s", e.getMessage()));
        }
        finally {
            tmpFile.delete();
        }
        this.dictImportDetailRepository.save((Object)importDetail);
        dictImport.setDetail(importDetail);
        dictImport.setExecuted(true);
        dictImport.setExecutor(user.getAccount());
        dictImport.setExecuteTime(new Date());
        dictImport.setExecuteResult(executeResult);
        this.dictImportRepository.save((Object)dictImport);
        return (DictImportVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictImport, DictImportVo.class, HashSet.class, ArrayList.class, new String[]{"detail"});
    }

    public DictImportVo findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        DictImportEntity dictImport = this.dictImportRepository.findDetailsById(id);
        return (DictImportVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictImport, DictImportVo.class, HashSet.class, ArrayList.class, new String[]{"detail"});
    }

    public List<DictImportVo> findAll() {
        List imports = this.dictImportRepository.findAll(Sort.by((Sort.Order[])new Sort.Order[]{Sort.Order.desc((String)"createTime")}));
        if (CollectionUtils.isEmpty((Collection)imports)) {
            return Lists.newArrayList();
        }
        List<DictImportEntity> dictImportEntities = this.loadUsers(imports);
        Collection dictImportVo = this.nebulaToolkitService.copyCollectionByWhiteList(dictImportEntities, DictImportEntity.class, DictImportVo.class, HashSet.class, ArrayList.class, new String[]{"detail"});
        return Lists.newArrayList((Iterable)dictImportVo);
    }

    private List<DictImportEntity> loadUsers(List<DictImportEntity> imports) {
        HashMap<String, UserVo> tmp = new HashMap<String, UserVo>();
        for (DictImportEntity anImport : imports) {
            String creator = anImport.getCreator();
            UserVo createUser = (UserVo)tmp.get(creator);
            if (createUser == null) {
                createUser = this.userService.findByAccount(creator);
                tmp.put(creator, createUser);
            }
            anImport.setCreateUser(createUser);
            String executor = anImport.getExecutor();
            if (!StringUtils.isNotBlank((CharSequence)executor)) continue;
            UserVo executeUser = (UserVo)tmp.get(executor);
            if (executeUser == null) {
                executeUser = this.userService.findByAccount(executor);
                tmp.put(executor, executeUser);
            }
            anImport.setExecuteUser(executeUser);
        }
        return imports;
    }
}

