/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.dictionary.service.local.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.dictionary.common.service.DictItemOrgMappingService;
import com.bizunited.platform.dictionary.common.service.dictItem.DictItemService;
import com.bizunited.platform.dictionary.common.vo.DictItemOrgMappingVo;
import com.bizunited.platform.dictionary.common.vo.DictItemVo;
import com.bizunited.platform.dictionary.service.local.entity.DictItemEntity;
import com.bizunited.platform.dictionary.service.local.entity.DictItemOrgMappingEntity;
import com.bizunited.platform.dictionary.service.local.repository.DictItemOrgMappingRepository;
import com.bizunited.platform.user.common.service.organization.OrganizationExtendService;
import com.bizunited.platform.user.common.service.organization.OrganizationService;
import com.bizunited.platform.user.common.vo.OrganizationExtendVo;
import com.bizunited.platform.user.common.vo.OrganizationVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.transaction.Transactional;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="DictItemOrgMappingServiceImpl")
public class DictItemOrgMappingServiceImpl
implements DictItemOrgMappingService {
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private DictItemService dictItemService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private DictItemOrgMappingRepository dictItemOrgMappingRepository;
    @Autowired
    private OrganizationExtendService organizationExtendService;

    @Transactional
    public OrganizationExtendVo createAndBindDictItem(OrganizationExtendVo vo, String id) {
        Validate.notNull((Object)vo, (String)"\u6269\u5c55\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)id, (String)"\u6570\u636e\u5b57\u5178\u503c\u4e3a\u7a7a\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getOrganization(), (String)"\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        OrganizationExtendVo organizationExtendVo = this.organizationExtendService.create(vo);
        this.bindOrgDictItem(vo.getOrganization().getCode(), id);
        return organizationExtendVo;
    }

    @Transactional
    public OrganizationExtendVo updateAndBindDictItem(OrganizationExtendVo vo, String id) {
        Validate.notNull((Object)vo, (String)"\u6269\u5c55\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)id, (String)"\u6570\u636e\u5b57\u5178\u503c\u4e3a\u7a7a\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.notNull((Object)vo.getOrganization(), (String)"\u7ec4\u7ec7\u673a\u6784\u4e3a\u7a7a\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        DictItemOrgMappingEntity entity = this.dictItemOrgMappingRepository.findByOrgCode(vo.getOrganization().getCode());
        DictItemVo dictItem = this.dictItemService.findDetailsById(id);
        DictItemEntity dictItemEntity = (DictItemEntity)((Object)this.nebulaToolkitService.copyObjectByWhiteList((Object)dictItem, DictItemEntity.class, HashSet.class, ArrayList.class, new String[0]));
        entity.setDictItem(dictItemEntity);
        entity.setOrgCode(vo.getOrganization().getCode());
        this.dictItemOrgMappingRepository.deleteByOrgCode(vo.getOrganization().getCode());
        this.dictItemOrgMappingRepository.save((Object)entity);
        OrganizationExtendVo organizationExtendVo = this.organizationExtendService.update(vo);
        this.bindOrgDictItem(vo.getOrganization().getCode(), id);
        return organizationExtendVo;
    }

    @Transactional
    public void bindOrgDictItem(String code, String dictItemId) {
        Validate.notBlank((CharSequence)code, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u5c42\u7ea7\u7ed1\u5b9a\u65f6\uff0c\u5fc5\u987b\u6307\u5b9a\u5f53\u524d\u7684\u7ec4\u7ec7\u673a\u6784\u4fe1\u606f!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)dictItemId, (String)"\u8fdb\u884c\u7ec4\u7ec7\u673a\u6784-\u5c42\u7ea7\u7ed1\u5b9a\u65f6,\u81f3\u5c11\u4f20\u5165\u6570\u636e\u5b57\u5178\u503c\u4e00\u4e2a\u4fe1\u606f!!", (Object[])new Object[0]);
        OrganizationVo organization = this.organizationService.findByCode(code);
        Validate.notNull((Object)organization, (String)"\u672a\u627e\u5230\u7ec4\u7ec7\u673a\u6784\uff1a%s", (Object[])new Object[]{code});
        DictItemVo vo = this.dictItemService.findDetailsById(dictItemId);
        Validate.notNull((Object)vo, (String)"\u672a\u627e\u5230\u6570\u636e\u5b57\u5178\u503c", (Object[])new Object[0]);
        DictItemOrgMappingEntity mapping = new DictItemOrgMappingEntity();
        DictItemEntity current = new DictItemEntity();
        current.setId(dictItemId);
        current.setDictKey(vo.getDictKey());
        current.setDictValue(vo.getDictValue());
        current.setDictSort(vo.getDictSort());
        mapping.setDictItem(current);
        mapping.setOrgCode(code);
        this.dictItemOrgMappingRepository.save((Object)mapping);
    }

    public Page<OrganizationVo> queryPage(String dictItemId, Pageable pageable) {
        PageImpl page;
        if (StringUtils.isBlank((CharSequence)dictItemId)) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        DictItemVo vo = this.dictItemService.findDetailsById(dictItemId);
        Integer sort = vo.getDictSort() - 1;
        if (sort < 1) {
            return new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        Page<DictItemOrgMappingEntity> entityPage = this.dictItemOrgMappingRepository.queryPage(sort, pageable);
        List content = entityPage.getContent();
        ArrayList<OrganizationVo> vos = new ArrayList<OrganizationVo>();
        if (!content.isEmpty()) {
            for (DictItemOrgMappingEntity entity : content) {
                OrganizationVo organizationVo = this.organizationService.findByCode(entity.getOrgCode());
                vos.add(organizationVo);
            }
            page = new PageImpl(new ArrayList(vos), pageable, entityPage.getTotalElements());
        } else {
            page = new PageImpl((List)Lists.newArrayList(), pageable, 0L);
        }
        return page;
    }

    public Page<JSONObject> findByConditions(String id, String orgName, String code, String createUser, Integer tstatus, Pageable pageable) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)0, (int)50));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("id", id);
        parameters.put("code", code);
        parameters.put("tstatus", tstatus);
        parameters.put("orgName", orgName);
        parameters.put("createUser", createUser);
        Page entityPage = this.dictItemOrgMappingRepository.findByConditions(parameters, pageable);
        List content = entityPage.getContent();
        if (CollectionUtils.isEmpty((Collection)content)) {
            return Page.empty((Pageable)pageable);
        }
        ArrayList<JSONObject> jsonObjects = new ArrayList<JSONObject>();
        Collection vos = this.nebulaToolkitService.copyCollectionByWhiteList((Iterable)content, DictItemOrgMappingEntity.class, DictItemOrgMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"dictItem"});
        for (DictItemOrgMappingVo vo : vos) {
            jsonObjects.add(this.buildProperty(vo));
        }
        return new PageImpl(new ArrayList(jsonObjects), pageable, entityPage.getTotalElements());
    }

    public List<OrganizationVo> findOrgByConditions(String dictItemId, String name) {
        if (StringUtils.isBlank((CharSequence)dictItemId)) {
            return Lists.newArrayList();
        }
        DictItemVo vo = this.dictItemService.findDetailsById(dictItemId);
        Integer sort = Integer.parseInt(vo.getDictValue());
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (sort <= 1) {
            return Lists.newArrayList();
        }
        Integer dictValue = sort - 1;
        parameters.put("dictValue", dictValue);
        parameters.put("name", name);
        List entityList = this.dictItemOrgMappingRepository.findOrgByConditions(parameters);
        ArrayList<OrganizationVo> vos = new ArrayList<OrganizationVo>();
        if (!entityList.isEmpty()) {
            for (DictItemOrgMappingEntity entity : entityList) {
                OrganizationVo organizationVo = this.organizationService.findByCode(entity.getOrgCode());
                vos.add(organizationVo);
            }
        }
        return vos;
    }

    public JSONObject findDetailByCode(String code) {
        Validate.notNull((Object)code, (String)"\u6839\u636e\u7ec4\u7ec7\u7f16\u7801\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f", (Object[])new Object[0]);
        DictItemOrgMappingEntity entity = this.dictItemOrgMappingRepository.findByOrgCode(code);
        DictItemOrgMappingVo vo = (DictItemOrgMappingVo)this.nebulaToolkitService.copyObjectByWhiteList((Object)entity, DictItemOrgMappingVo.class, LinkedHashSet.class, ArrayList.class, new String[]{"dictItem"});
        return this.buildProperty(vo);
    }

    private JSONObject buildProperty(DictItemOrgMappingVo vo) {
        OrganizationVo organization = this.organizationService.findByCode(vo.getOrgCode());
        Validate.notNull((Object)organization, (String)"\u4e0d\u5b58\u5728code\u4e3a[%s]\u7684\u7ec4\u7ec7\u673a\u6784,\u8bf7\u68c0\u67e5!", (Object[])new Object[]{vo.getOrgCode()});
        OrganizationVo org = this.organizationService.findDetailsById(organization.getId());
        JSONObject jsonitem = new JSONObject();
        jsonitem.put("id", (Object)org.getId());
        jsonitem.put("code", (Object)org.getCode());
        jsonitem.put("orgName", (Object)org.getOrgName());
        jsonitem.put("dictItemId", (Object)vo.getDictItem().getId());
        jsonitem.put("dictValue", (Object)vo.getDictItem().getDictKey());
        if (org.getParent() != null) {
            jsonitem.put("parentName", (Object)org.getParent().getOrgName());
        } else {
            jsonitem.put("parentName", null);
        }
        jsonitem.put("tstatus", (Object)org.getTstatus());
        jsonitem.put("createUser", (Object)org.getCreateUser());
        jsonitem.put("createTime", (Object)org.getCreateTime());
        jsonitem.put("updateTime", (Object)org.getUpdateTime());
        jsonitem.put("updateUser", (Object)org.getUpdateUser());
        return jsonitem;
    }
}

