package com.bizunited.platform.kuiper.starter.common.excel;

/**
 * Excel区域bean(预留后续扩展使用)
 *
 * @author Keller
 * @create 2020/8/25
 */
public class CellRegion {

  /**
   * 首行
   */
  private Integer firstRow;
  /**
   * 尾行
   */
  private Integer footRow;
  /**
   * 首列
   */
  private Integer firstCol;
  /**
   * 尾列
   */
  private Integer footCol;

  public CellRegion() {
    super();
  }

  /***
   *
   * @param firstRow
   *            首行
   * @param footRow
   *            尾行
   * @param firstCol
   *            首列
   * @param footCol
   *            尾列
   */
  public CellRegion(Integer firstRow, Integer footRow, Integer firstCol, Integer footCol) {
    super();
    this.firstRow = firstRow;
    this.footRow = footRow;
    this.firstCol = firstCol;
    this.footCol = footCol;
  }

  public void setRegion(Integer firstRow, Integer footRow, Integer firstCol, Integer footCol) {
    this.firstRow = firstRow;
    this.footRow = footRow;
    this.firstCol = firstCol;
    this.footCol = footCol;
  }

  public void setFirstRow(Integer firstRow) {
    this.firstRow = firstRow;
  }

  public Integer getFirstRow() {
    return firstRow;
  }

  public Integer getFootRow() {
    return footRow;
  }

  public void setFootRow(Integer footRow) {
    this.footRow = footRow;
  }

  public Integer getFirstCol() {
    return firstCol;
  }

  public void setFirstCol(Integer firstCol) {
    this.firstCol = firstCol;
  }

  public Integer getFootCol() {
    return footCol;
  }

  public void setFootCol(Integer footCol) {
    this.footCol = footCol;
  }

  @Override
  public String toString() {
    return "CellRegion [firstRow=" + firstRow + ", footRow=" + footRow + ", firstCol=" + firstCol + ", footCol=" + footCol + "]";
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((firstCol == null) ? 0 : firstCol.hashCode());
    result = prime * result + ((firstRow == null) ? 0 : firstRow.hashCode());
    result = prime * result + ((footCol == null) ? 0 : footCol.hashCode());
    result = prime * result + ((footRow == null) ? 0 : footRow.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (getClass() != obj.getClass()) {
      return false;
    }
    CellRegion other = (CellRegion) obj;
    if (firstCol == null) {
      if (other.firstCol != null) {
        return false;
      }
    } else if (!firstCol.equals(other.firstCol)) {
      return false;
    }
    if (firstRow == null) {
      if (other.firstRow != null) {
        return false;
      }
    } else if (!firstRow.equals(other.firstRow)) {
      return false;
    }
    if (footCol == null) {
      if (other.footCol != null) {
        return false;
      }
    } else if (!footCol.equals(other.footCol)) {
      return false;
    }
    if (footRow == null) {
      if (other.footRow != null) {
        return false;
      }
    } else if (!footRow.equals(other.footRow)) {
      return false;
    }
    return true;
  }

}
