package com.bizunited.platform.kuiper.starter.common.excel;

import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;

/**
 * ExcelExportWrapper构造器
 *
 * @author Keller
 * @create 2020/8/27
 */
public class ExcelExportWrapperBuilder {

  private static final Logger LOGGER = LoggerFactory.getLogger(ExcelExportWrapperBuilder.class);

  /**
   * 隐藏public构造函数
   */
  private ExcelExportWrapperBuilder() {
  }

  /**
   * 通过输入流构造ExcelExportWrapper
   *
   * @param input
   * @return
   */
  public static ExcelExportWrapper build(InputStream input) {
    return new ExcelExportWrapper(input);
  }

  /**
   * 通过文件构建ExcelExportWrapper
   *
   * @param file
   * @return
   */
  public static ExcelExportWrapper build(File file) {
    Workbook wb = null;
    try {
      wb = WorkbookFactory.create(file);
    } catch (IOException e) {
      LOGGER.error(e.getMessage(), e);
      throw new IllegalArgumentException("创建Execl文件出错");
    }
    return new ExcelExportWrapper(wb);
  }

  /**
   * 构建SXSSFWorkbook形式ExcelExportWrapper
   *
   * @return
   */
  public static ExcelExportWrapper buildWithSXSSFWorkbook() {
    Workbook wb = new SXSSFWorkbook();
    return new ExcelExportWrapper(wb);
  }
}
