package com.bizunited.platform.kuiper.starter.common.excel.exception;

import com.bizunited.platform.kuiper.starter.common.excel.NebulaExcelColumn;
import org.apache.commons.lang3.StringUtils;

/**
 * Excel 导入导出异常
 *
 * @author Keller
 * @create 2020/8/24
 */
public class ExcelMigrateException extends RuntimeException {

  private static final long serialVersionUID = 4006108491511256565L;

  public ExcelMigrateException(NebulaExcelColumn nebulaExcelColumn, String message) {
    super(StringUtils.isBlank(nebulaExcelColumn.errorMessage()) ? message : nebulaExcelColumn.errorMessage());

  }

  public ExcelMigrateException(NebulaExcelColumn nebulaExcelColumn, String message, Throwable cause) {
    super(StringUtils.isBlank(nebulaExcelColumn.errorMessage()) ? message : nebulaExcelColumn.errorMessage(), cause);
  }

  public ExcelMigrateException(String message) {
    super(message);
  }

  public ExcelMigrateException(String message, Throwable cause) {
    super(message, cause);
  }

  public ExcelMigrateException(Throwable cause) {
    super(cause);
  }

  public ExcelMigrateException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
    super(message, cause, enableSuppression, writableStackTrace);
  }
}
