package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.FormDetailsExportBoxEntity;
import com.bizunited.platform.kuiper.starter.vo.FormDetailsExportBoxVo;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.Map;
import java.util.Set;

/**
 * 基于表单引擎，列表引擎，对业务数据通过工具箱方式导出的相关操作
 *
 * @author Keller
 * @create 2020/8/25
 */
public interface FormDetailsExportBoxService {

  /**
   * 创建导出记录
   *
   * @param exportField      导出字段json信息
   * @param exportParam      导出数据查询使用参数 json信息
   * @param processClassName 导出处理类
   * @param params           导出扩展参数
   * @return
   */

  /**
   * @param formDetailsExportBoxVo 导出参数vo
   * @param params                 导出扩展参数
   * @return
   */
  FormDetailsExportBoxEntity export(FormDetailsExportBoxVo formDetailsExportBoxVo, Map<String, Object> params);


  /**
   * 查询导出记录信息
   *
   * @param id
   * @return
   */
  FormDetailsExportBoxEntity findById(String id);

  /**
   * 查询所有导入记录信息（分页）
   *
   * @param pageable
   * @return
   */
  Page<FormDetailsExportBoxEntity> queryPage(Pageable pageable);

  /**
   * 按照主键进行信息的逻辑删除
   *
   * @param id 主键
   */
  void deleteById(String id);

  /**
   * 逻辑删除所有数据
   */
  void deleteAll();

  /**
   * 按照主键进行导入信息进程的取消
   *
   * @param id 主键
   */
  void cancel(String id);

  /**
   * 下载导出数据
   *
   * @param id
   * @return
   */
  byte[] download(String id);

  /**
   * 获取所有处理类名称
   *
   * @return
   */
  Set<String> findProcessClassNames();

}
