package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.FormDetailsExportBoxEntity;
import com.bizunited.platform.kuiper.starter.service.instances.imports.FormDetailsExportBoxProcess;

import java.util.Map;

/**
 * 数据导出异步任务
 *
 * @author Keller
 * @create 2020/8/25
 */
public interface FormDetailsExportBoxTaskService {

  /**
   * 异步执行导出进程
   *
   * @param entity  导入记录信息
   * @param process 客户自定义实现业务导出数据处理类
   * @param account 操作账号
   * @param params  扩展参数
   */
  void exportProcess(FormDetailsExportBoxEntity entity, FormDetailsExportBoxProcess<?> process, String account, Map<String, Object> params);
}
