package com.bizunited.platform.kuiper.entity;

import com.bizunited.platform.common.entity.UuidEntity;
import com.bizunited.platform.saturn.engine.annotation.SaturnColumn;
import com.bizunited.platform.user.common.vo.UserVo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;
import javax.persistence.Transient;
import java.util.Date;

/**
 * 该功能模型用于记录，基于列表模板的批量业务数据导出功能的导出状态、导文件数据的信息
 *
 * @author Keller
 * @create 2020/8/25
 */
@Entity
@Table(name = "engine_form_details_export_box")
@ApiModel(value = "FormDetailsExportBoxEntity", description = "该功能模型用于记录，基于列表模板的批量业务数据导出功能的导出状态、导文件数据的信息")
@org.hibernate.annotations.Table(appliesTo = "engine_form_details_export_box", comment = "该功能模型用于记录，基于列表模板的批量业务数据导出功能的导出状态、导文件数据的信息")
public class FormDetailsExportBoxEntity extends UuidEntity {

  private static final long serialVersionUID = -5183368266432605135L;

  /**
   * 文件在本地存储路径
   */
  @Column(name = "relative_local", length = 255, nullable = true, columnDefinition = "varchar(255) COMMENT '文件在本地存储路径'")
  @ApiModelProperty(name = "relativeLocal", value = "文件在本地存储路径", required = false)
  @SaturnColumn(description = "文件在本地存储路径")
  private String relativeLocal;

  /**
   * 文件名字
   */
  @ApiModelProperty(name = "fileName", value = "本地文件名字", required = false)
  @Column(name = "file_name", nullable = true, columnDefinition = "varchar(255) COMMENT '本地文件名字'")
  @SaturnColumn(description = "本地文件名字")
  private String fileName;

  /**
   * 任务执行人
   */
  @Column(name = "executor", columnDefinition = "varchar(255) COMMENT '任务执行人'")
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private String executor;

  /**
   * 任务执行人
   */
  @Transient
  @ApiModelProperty(name = "executor", value = "任务执行人")
  @SaturnColumn(description = "任务执行人")
  private UserVo executeUser;

  /**
   * 执行开始时间
   */
  @Column(name = "execute_start_time", columnDefinition = "datetime COMMENT '执行开始时间'")
  @ApiModelProperty(name = "executeStartTime", value = "执行开始时间")
  @SaturnColumn(description = "执行开始时间")
  private Date executeStartTime;

  /**
   * 执行结束时间
   */
  @Column(name = "execute_end_time", columnDefinition = "datetime COMMENT '执行结束时间'")
  @ApiModelProperty(name = "executeEndTime", value = "执行结束时间")
  @SaturnColumn(description = "执行结束时间")
  private Date executeEndTime;

  /**
   * 执行结果，2：进行中，1：已完成，0：已取消
   */
  @ApiModelProperty("执行结果，2：进行中，1：已完成，0：已取消")
  @SaturnColumn(description = "执行结果，2：进行中，1：已完成，0：已取消")
  @Column(name = "execute_result", columnDefinition = "int(11) COMMENT '执行结果，2：进行中，1：已完成，0：已取消'")
  private Integer executeResult;

  /**
   * 删除标识  true:已删除，false：未删除
   */
  @ApiModelProperty(name = "isDelete", value = "删除标识", required = true)
  @SaturnColumn(description = "删除标识")
  @Column(name = "is_delete", nullable = false, columnDefinition = "bit(1) default 0 comment '删除标识'")
  private Boolean isDelete;

  /**
   * 导出处理类
   */
  @Column(name = "process_class_name", nullable = true, columnDefinition = "varchar(255) COMMENT '导出处理类'")
  @ApiModelProperty(name = "processClassName", value = "导出处理类", required = false)
  @SaturnColumn(description = "导出处理类")
  private String processClassName;

  /**
   * 导出字段参数
   */
  @Column(name = "export_field", nullable = true, columnDefinition = "varchar(2000) COMMENT '导出字段参数'")
  @ApiModelProperty(name = "exportField", value = "导出字段参数", required = false)
  @SaturnColumn(description = "导出字段参数")
  private String exportField;

  /**
   * 导出查询参数
   */
  @Column(name = "export_param", nullable = true, columnDefinition = "varchar(2000) COMMENT '导出查询参数'")
  @ApiModelProperty(name = "exportParam", value = "导出查询参数", required = false)
  @SaturnColumn(description = "导出查询参数")
  private String exportParam;

  /**
   * 导出数据视图编号
   */
  @Column(name = "data_view_code", nullable = true, columnDefinition = "varchar(255) COMMENT '导出数据视图参数'")
  @ApiModelProperty(name = "dataViewCode", value = "导出数据视图编号", required = false)
  @SaturnColumn(description = "导出数据视图编号")
  private String dataViewCode;

  /**
   * 模板名称
   */
  @Column(name = "template_name", nullable = true, columnDefinition = "varchar(255) COMMENT '模板名称'")
  @ApiModelProperty(name = "templateName", value = "模板名称", required = false)
  @SaturnColumn(description = "模板名称")
  private String templateName;

  /**
   * 模板编号
   */
  @Column(name = "template_code", nullable = true, columnDefinition = "varchar(255) COMMENT '模板编号'")
  @ApiModelProperty(name = "templateCode", value = "模板编号", required = false)
  @SaturnColumn(description = "模板编号")
  private String templateCode;

  /**
   * 模板版本
   */
  @Column(name = "template_version", nullable = true, columnDefinition = "varchar(255) COMMENT '模板版本'")
  @ApiModelProperty(name = "templateVersion", value = "模板版本", required = false)
  @SaturnColumn(description = "模板版本")
  private String templateVersion;

  /**
   * 列表模板名称
   */
  @Column(name = "list_template_name", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板名称'")
  @ApiModelProperty(name = "listTemplateName", value = "列表模板名称", required = false)
  @SaturnColumn(description = "列表模板编号")
  private String listTemplateName;

  /**
   * 列表模板编号
   */
  @Column(name = "list_template_code", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板编号'")
  @ApiModelProperty(name = "listTemplateCode", value = "列表模板编号", required = false)
  @SaturnColumn(description = "列表模板编号")
  private String listTemplateCode;

  /**
   * 列表模板版本
   */
  @Column(name = "list_template_version", nullable = true, columnDefinition = "varchar(255) COMMENT '列表模板版本'")
  @ApiModelProperty(name = "listTemplateVersion", value = "列表模板版本", required = false)
  @SaturnColumn(description = "列表模板版本")
  private String listTemplateVersion;

  /**
   * 下载文件名字
   */
  @ApiModelProperty(name = "downloadFileName", value = "下载文件名字", required = false)
  @Column(name = "download_file_name", nullable = true, columnDefinition = "varchar(255) COMMENT '下载文件名字'")
  @SaturnColumn(description = "下载文件名字")
  private String downloadFileName;

  /**
   * 当前项目名工程名
   */
  @ApiModelProperty("当前项目名工程名")
  @Column(name="project_name", nullable = false, columnDefinition = "varchar(255) default '' comment '工程名'")
  @SaturnColumn(description = "工程名")
  private String projectName;

  public String getProjectName() {
    return projectName;
  }

  public void setProjectName(String projectName) {
    this.projectName = projectName;
  }

  public String getDataViewCode() {
    return dataViewCode;
  }

  public void setDataViewCode(String dataViewCode) {
    this.dataViewCode = dataViewCode;
  }

  public String getRelativeLocal() {
    return relativeLocal;
  }

  public void setRelativeLocal(String relativeLocal) {
    this.relativeLocal = relativeLocal;
  }

  public String getFileName() {
    return fileName;
  }

  public void setFileName(String fileName) {
    this.fileName = fileName;
  }

  public String getExecutor() {
    return executor;
  }

  public void setExecutor(String executor) {
    this.executor = executor;
  }

  public UserVo getExecuteUser() {
    return executeUser;
  }

  public void setExecuteUser(UserVo executeUser) {
    this.executeUser = executeUser;
  }

  public Date getExecuteStartTime() {
    return executeStartTime;
  }

  public void setExecuteStartTime(Date executeStartTime) {
    this.executeStartTime = executeStartTime;
  }

  public Date getExecuteEndTime() {
    return executeEndTime;
  }

  public void setExecuteEndTime(Date executeEndTime) {
    this.executeEndTime = executeEndTime;
  }

  public Integer getExecuteResult() {
    return executeResult;
  }

  public void setExecuteResult(Integer executeResult) {
    this.executeResult = executeResult;
  }

  public Boolean getDelete() {
    return isDelete;
  }

  public void setDelete(Boolean delete) {
    isDelete = delete;
  }

  public String getProcessClassName() {
    return processClassName;
  }

  public void setProcessClassName(String processClassName) {
    this.processClassName = processClassName;
  }

  public String getExportField() {
    return exportField;
  }

  public void setExportField(String exportField) {
    this.exportField = exportField;
  }

  public String getExportParam() {
    return exportParam;
  }

  public void setExportParam(String exportParam) {
    this.exportParam = exportParam;
  }

  public String getTemplateName() {
    return templateName;
  }

  public void setTemplateName(String templateName) {
    this.templateName = templateName;
  }

  public String getTemplateCode() {
    return templateCode;
  }

  public void setTemplateCode(String templateCode) {
    this.templateCode = templateCode;
  }

  public String getTemplateVersion() {
    return templateVersion;
  }

  public void setTemplateVersion(String templateVersion) {
    this.templateVersion = templateVersion;
  }

  public String getListTemplateName() {
    return listTemplateName;
  }

  public void setListTemplateName(String listTemplateName) {
    this.listTemplateName = listTemplateName;
  }

  public String getListTemplateCode() {
    return listTemplateCode;
  }

  public void setListTemplateCode(String listTemplateCode) {
    this.listTemplateCode = listTemplateCode;
  }

  public String getListTemplateVersion() {
    return listTemplateVersion;
  }

  public void setListTemplateVersion(String listTemplateVersion) {
    this.listTemplateVersion = listTemplateVersion;
  }

  public String getDownloadFileName() {
    return downloadFileName;
  }

  public void setDownloadFileName(String downloadFileName) {
    this.downloadFileName = downloadFileName;
  }
}
